/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import com.mojang.serialization.MapCodec;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FlowerVineBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<FlowerVineBlock> CODEC = FlowerVineBlock.simpleCodec(FlowerVineBlock::new);
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public FlowerVineBlock(BlockBehaviour.Properties props) {
        super(props, Direction.UP, SHAPE, false, 0.1);
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return randomSource.nextInt(3, 6);
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    @NotNull
    protected Block getBodyBlock() {
        return (Block)ReactiveBlocks.FLOWER_VINES_BODY.get();
    }
}

