/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public interface ChainDisplacingBlock {
    public boolean stateMatchesSelf(BlockState var1);

    default public void breadthFirstDisplace(Level level, BlockPos source, boolean displace_surroundings) {
        this.breadthFirstDisplace(level, source, displace_surroundings, 20);
    }

    default public void breadthFirstDisplace(Level level, BlockPos source, boolean displace_surroundings, int source_displace_duration) {
        int max = (Integer)ConfigMan.COMMON.maxDisplaceCount.get();
        ArrayDeque<BlockPos> displace_queue = new ArrayDeque<BlockPos>();
        displace_queue.add(source);
        int count = 0;
        BlockPos prior = null;
        while (!displace_queue.isEmpty()) {
            BlockPos target = (BlockPos)displace_queue.poll();
            boolean found_child = false;
            if (count <= max) {
                ArrayList<Direction> shuffled_directions = new ArrayList<Direction>(List.of(Direction.values()));
                Collections.shuffle(shuffled_directions);
                for (Direction direction : shuffled_directions) {
                    BlockPos next_target = target.relative(direction);
                    if (displace_queue.contains(next_target) || !level.isLoaded(next_target)) continue;
                    BlockPos conduct_start = next_target;
                    while (level.getBlockState(next_target).is(AlchemyTags.displaceConductive) && next_target.closerThan((Vec3i)conduct_start, (double)((Integer)ConfigMan.COMMON.displaceConductRange.get()).intValue())) {
                        next_target = next_target.relative(direction);
                    }
                    if (this.stateMatchesSelf(level.getBlockState(next_target))) {
                        displace_queue.add(next_target);
                        found_child = true;
                        ++count;
                        continue;
                    }
                    if (!displace_surroundings || level.getBlockState(next_target).isAir() || level.getBlockState(next_target).is((Block)ReactiveBlocks.VOLT_CELL.get()) || level.getBlockState(next_target).is((Block)ReactiveBlocks.DISPLACED_BLOCK.get())) continue;
                    DisplacedBlock.displaceWithChain(level.getBlockState(next_target), next_target, level, 2 + count, count, target);
                }
            }
            if (target.equals((Object)source)) {
                DisplacedBlock.displace(level.getBlockState(target), target, level, source_displace_duration);
            } else if (source != null) {
                DisplacedBlock.displaceWithChain(level.getBlockState(target), target, level, 2 + count, count, prior);
            } else {
                DisplacedBlock.displace(level.getBlockState(target), target, level, 10 + count);
            }
            if (!found_child) continue;
            prior = target;
        }
    }
}

