/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StaffBlockEntity
extends BlockEntity {
    public ItemStack stack;
    private final String ITEM_STACK_TAG = "Stack";

    public StaffBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.STAFF.get(), pos, state);
        this.stack = state.getBlock().asItem().getDefaultInstance();
    }

    protected void saveAdditional(@NotNull CompoundTag main_tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registry_provider) {
        super.saveAdditional(main_tag, registry_provider);
        main_tag.put("Stack", this.stack.save(registry_provider));
    }

    protected void loadAdditional(CompoundTag main_tag, HolderLookup.Provider registry_provider) {
        super.loadAdditional(main_tag, registry_provider);
        Tag tag = main_tag.get("Stack");
        if (tag == null) {
            this.stack = ItemStack.EMPTY;
            return;
        }
        Optional possible_stack = ItemStack.parse((HolderLookup.Provider)registry_provider, (Tag)tag);
        possible_stack.ifPresent(itemStack -> {
            this.stack = itemStack;
        });
    }
}

