/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.blocks.GravityBeamBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import dev.hyperlynx.reactive.util.BeamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class GravityBeamBlockEntity
extends BlockEntity {
    public GravityBeamBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.GRAVITY_BEAM.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.getValue((Property)GravityBeamBlock.ENABLED)).booleanValue()) {
            return;
        }
        BlockHitResult hit = BeamHelper.rayTrace(level, GravityBeamBlockEntity.start_pos(pos, (Direction)state.getValue((Property)GravityBeamBlock.FACING)), GravityBeamBlockEntity.xrot(state), GravityBeamBlockEntity.yrot(state), ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, 32.0, CollisionContext.empty());
        Vec3 particle_start = Vec3.atCenterOf((Vec3i)pos);
        particle_start.add(0.0, 0.1, 0.0);
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.END_ROD, particle_start, Vec3.atCenterOf((Vec3i)hit.getBlockPos()), 1, 0.05);
        AABB effect_region = new AABB(Vec3.atCenterOf((Vec3i)pos).add(-0.1, -0.1, -0.1), Vec3.atCenterOf((Vec3i)hit.getBlockPos()).add(0.1, 0.1, 0.1));
        for (Entity target : level.getEntitiesOfClass(Entity.class, effect_region)) {
            if (target instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)target;
                victim.addEffect(new MobEffectInstance(ReactiveMobEffects.NULL_GRAVITY, 5));
                victim.resetFallDistance();
                continue;
            }
            if (!(target instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)target;
            item.setNoGravity(true);
        }
    }

    private static Vec3 start_pos(BlockPos center, Direction facing) {
        return Vec3.atCenterOf((Vec3i)center).relative(facing, 1.01);
    }

    private static float xrot(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        if (facing.equals((Object)Direction.UP)) {
            return 270.0f;
        }
        if (facing.equals((Object)Direction.DOWN)) {
            return 90.0f;
        }
        return 0.0f;
    }

    private static float yrot(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DirectionalBlock.FACING);
        return facing.toYRot();
    }
}

