/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class GatewayBlockEntity
extends TheEndPortalBlockEntity {
    private int tick_count;
    private static final int STARTUP_DURATION = 50;
    private int startup_timer = 0;
    public GlobalPos target;
    private final String TARGET_POS_TAG = "Target";
    private final String TARGET_DIMENSION_TAG = "Dimension";

    public GatewayBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ReactiveBlockEntityTypes.GATEWAY.get(), pos, blockState);
        Random random = new Random(pos.hashCode());
        this.tick_count = random.nextInt(0, 12000);
    }

    public boolean shouldRenderFace(Direction face) {
        return true;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos ignoredBlockPos, BlockState ignoredBlockState, T t) {
        if (level.isClientSide() && t instanceof GatewayBlockEntity) {
            GatewayBlockEntity gateway = (GatewayBlockEntity)t;
            ++gateway.tick_count;
            if (gateway.startup_timer < 50) {
                ++gateway.startup_timer;
            }
        }
    }

    public float totalTick(float partialTick) {
        return (float)this.tick_count + partialTick;
    }

    public float startupProportion(float partialTick) {
        if (this.startup_timer >= 50) {
            return 1.0f;
        }
        float x = ((float)this.startup_timer + partialTick) / 50.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(x - 1.0f, 3.0) + (double)c1 * Math.pow(x - 1.0f, 2.0));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.target == null) {
            return;
        }
        tag.put("Target", NbtUtils.writeBlockPos((BlockPos)this.target.pos()));
        tag.put("Dimension", (Tag)StringTag.valueOf((String)String.valueOf(this.target.dimension().location())));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        Optional pos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"Target");
        if (pos.isEmpty()) {
            return;
        }
        ResourceLocation location = ResourceLocation.parse((String)Objects.requireNonNull(tag.get("Dimension")).getAsString());
        this.target = GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location), (BlockPos)((BlockPos)pos.get()));
    }
}

