/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.menu.DeskMenu;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class DeskBlockEntity
extends BaseContainerBlockEntity
implements IItemHandlerModifiable {
    @NotNull
    private ItemStack stack = ItemStack.EMPTY;

    public DeskBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ReactiveBlockEntityTypes.DESK.get(), pos, blockState);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.reactive.desk");
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{this.stack});
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.stack = (ItemStack)items.getFirst();
        if (items.size() > 1) {
            throw new IllegalArgumentException("Desk block entity cannot accept more then one ItemStack.");
        }
        this.setChanged();
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new DeskMenu(containerId, inventory);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("stack")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("stack"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.stack.isEmpty()) {
            tag.put("stack", this.stack.save(registries));
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.stack;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack stack_to_insert, boolean simulate) {
        if (!this.isItemValid(slot, stack_to_insert)) {
            return stack_to_insert;
        }
        if (this.stack.isEmpty()) {
            this.stack = stack_to_insert.copy();
            return ItemStack.EMPTY;
        }
        if (!Objects.equals(stack_to_insert.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()), this.stack.get((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get()))) {
            return stack_to_insert;
        }
        int number_to_move = Math.min(this.stack.getMaxStackSize() - this.stack.getCount(), stack_to_insert.getCount());
        ItemStack after_items_depleted = stack_to_insert.copyWithCount(stack_to_insert.getCount() - number_to_move);
        if (!simulate) {
            this.stack.setCount(this.stack.getCount() + number_to_move);
        }
        return after_items_depleted;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return ItemStack.EMPTY;
        }
        if (amount > this.stack.getCount()) {
            return ItemStack.EMPTY;
        }
        ItemStack extracted = this.stack.copyWithCount(amount);
        if (!simulate) {
            this.stack.shrink(amount);
            if (this.stack.getCount() == 0) {
                this.stack = ItemStack.EMPTY;
            }
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && stack.is((Item)ReactiveItems.MATERIAL.get());
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        this.setItems((NonNullList<ItemStack>)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{stack}));
    }
}

