/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import com.mojang.datafixers.util.Either;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBottleInsertContext;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.net.ReactionStatusPayload;
import dev.hyperlynx.reactive.recipes.CrucibleRecipeInput;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.recipes.PrecipitateRecipe;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.registration.ReactiveRecipes;
import dev.hyperlynx.reactive.util.AreaMemory;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;

public class CrucibleBlockEntity
extends BlockEntity
implements Reactor {
    public static final int CRUCIBLE_MAX_POWER = 1600;
    private final HashMap<Power, Integer> powers = new HashMap();
    public final AreaMemory areaMemory;
    private int tick_counter = 0;
    private int process_stage = 0;
    private int gather_stage = 0;
    public final Color mix_color = Color.black();
    public boolean color_changed = true;
    private final Color next_mix_color = Color.black();
    public boolean color_initialized = false;
    public int electricCharge = 0;
    public int integrity = 100;
    public int enderRiftStrength = 0;
    public EndCrystal linked_crystal = null;
    public boolean used_crystal_this_cycle = false;
    public final SculkSpreader sculkSpreader = SculkSpreader.createLevelSpreader();
    public List<ReactionStatusEntry> reaction_status = new ArrayList<ReactionStatusEntry>();
    public final List<String> reactions_to_render = new LinkedList<String>();
    public boolean reactions_paused = false;

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.CRUCIBLE.get(), pos, state);
        NeoForge.EVENT_BUS.register((Object)this);
        this.areaMemory = new AreaMemory(pos);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        try {
            ++crucible.tick_counter;
            if (!level.isClientSide && crucible.enderRiftStrength > 0) {
                crucible.enderRiftStrength = SpecialCaseMan.tryTeleportNearbyEntity(crucible.getBlockPos(), crucible.getLevel(), crucible.getBlockPos(), true) ? 0 : crucible.enderRiftStrength - 1;
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5625 + level.random.nextDouble() * 2.0, (double)pos.getZ() + 0.5, 1, level.random.nextGaussian(), 0.0, level.random.nextGaussian(), 0.0);
            }
            if (crucible.tick_counter >= (Integer)ConfigMan.COMMON.crucibleTickDelay.get()) {
                crucible.tick_counter = 1;
                if (!((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
                    CrucibleBlockEntity.empty(level, pos, state, crucible);
                }
                switch (crucible.process_stage) {
                    case 0: {
                        if (level.getBlockState(pos.below()).is((Block)ReactiveBlocks.VOLT_CELL.get()) && crucible.electricCharge < 15) {
                            crucible.electricCharge = 15;
                        } else if (crucible.electricCharge > 0) {
                            --crucible.electricCharge;
                        }
                        if (!level.isClientSide() && !((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue() && crucible.areaMemory.existsAbove(crucible.level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)ReactiveBlocks.WARP_SPONGE.get())) {
                            level.setBlock(crucible.getBlockPos(), (BlockState)level.getBlockState(crucible.getBlockPos()).setValue((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(true)), 2);
                            level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.6f, 1.0f);
                            level.gameEvent((Holder)GameEvent.FLUID_PLACE, pos, GameEvent.Context.of((BlockState)state));
                        }
                        if (level.getBlockState(pos.below()).is((Block)ReactiveBlocks.CURSE_CELL.get())) {
                            boolean hungers = true;
                            for (Power base_power : ReactionMan.BASE_POWER_LIST) {
                                if (crucible.getPowerLevel(base_power) <= 0) continue;
                                hungers = false;
                                crucible.expendPower(base_power, WorldSpecificValue.get("curse_cell_draw_rate:" + base_power.getId(), 16, 45));
                            }
                            ParticleScribe.drawParticleBox(level, (ParticleOptions)ParticleTypes.ASH, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)pos.below()), (double)1.0, (double)1.0, (double)1.0), 2);
                            if (hungers) {
                                --crucible.integrity;
                            }
                        } else if (crucible.integrity < 100 && crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 1) {
                            crucible.integrity += 2;
                        } else if (crucible.integrity < 100 && crucible.integrity > 10) {
                            crucible.integrity += Math.min(10, 100 - crucible.integrity);
                        } else if (crucible.integrity < 10) {
                            --crucible.integrity;
                        }
                        crucible.integrity = Math.min(crucible.integrity, 100);
                        break;
                    }
                    case 1: {
                        if (level.isClientSide() || !((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) break;
                        CrucibleBlockEntity.gatherPower(level, crucible);
                        break;
                    }
                    case 2: {
                        if (level.isClientSide() || !((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue() || crucible.integrity <= 70 || !CrucibleBlockEntity.processItemsInside(level, pos, state, crucible)) break;
                        level.playSound(null, pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 0.65f + level.getRandom().nextFloat() / 5.0f);
                        level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)state));
                        break;
                    }
                    case 3: {
                        if (!level.isClientSide() && ((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
                            crucible.react((ServerLevel)level);
                        }
                        crucible.sculkSpreader.updateCursors((LevelAccessor)level, crucible.getBlockPos(), level.random, true);
                        crucible.reactions_paused = false;
                        break;
                    }
                    case 4: {
                        CrucibleBlockEntity.checkIntegrity(level, pos, state, crucible);
                        CrucibleBlockEntity.clearEmptyPowers(crucible);
                        crucible.setDirty();
                        crucible.process_stage = -1;
                        break;
                    }
                    default: {
                        System.err.println("Crucible ran out of steps! This can't be!");
                    }
                }
                ++crucible.process_stage;
            }
        }
        catch (Exception e) {
            ParticleScribe.drawParticleCrucibleTop(level, (ParticleOptions)ParticleTypes.ANGRY_VILLAGER, crucible.getBlockPos());
            ReactiveMod.LOGGER.error("Encountered an unexpected error when ticking the crucible at {}: ", (Object)crucible.getBlockPos(), (Object)e);
            CrucibleBlockEntity.empty(level, pos, state, crucible);
        }
    }

    private static void clearEmptyPowers(CrucibleBlockEntity crucible) {
        Set<Power> powers = Set.copyOf(crucible.powers.keySet());
        for (Power p : powers) {
            if (crucible.powers.get(p) != 0) continue;
            crucible.powers.remove(p);
        }
    }

    private static void checkIntegrity(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (crucible.integrity < 70) {
            crucible.expendAnyPowerExcept(null, 1);
        }
        if (crucible.integrity < 50 && crucible.integrity > 10) {
            ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 0.7, 0.9, 1);
        }
        if (crucible.integrity < 20 && crucible.integrity > 12) {
            level.playSound(null, pos, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 0.3f, 0.9f);
        }
        if (crucible.integrity == 10) {
            if (((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
                crucible.addPower((Power)Powers.MIND_POWER.get(), 23);
            }
            level.playSound(null, pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 0.2f, 0.9f);
            level.gameEvent((Holder)GameEvent.EXPLODE, pos, GameEvent.Context.of((BlockState)state));
            --crucible.integrity;
        } else if (crucible.integrity == 2) {
            level.playSound(null, pos, SoundEvents.CHAIN_BREAK, SoundSource.BLOCKS, 1.0f, 0.9f);
            level.gameEvent((Holder)GameEvent.EXPLODE, pos, GameEvent.Context.of((BlockState)state));
        } else if (crucible.integrity == 1) {
            level.playSound(null, pos, SoundEvents.GENERIC_BURN, SoundSource.BLOCKS, 1.0f, 0.9f);
            level.gameEvent((Holder)GameEvent.EXPLODE, pos, GameEvent.Context.of((BlockState)state));
        } else if (crucible.integrity < 1) {
            CrucibleBlockEntity.empty(level, pos, state, crucible);
            CrucibleBlockEntity.integrityFail(level, pos, state);
        }
    }

    public static void integrityFail(Level level, BlockPos pos, BlockState state) {
        ParticleScribe.drawParticleRing(level, (ParticleOptions)ReactiveParticles.RUNE, pos, 0.7, 0.9, 20);
        level.playSound(null, pos, (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.BLOCKS, 1.15f, 0.8f);
        level.explode(null, Vec3.atCenterOf((Vec3i)pos).x, Vec3.atCenterOf((Vec3i)pos).y, Vec3.atCenterOf((Vec3i)pos).z, 0.1f, Level.ExplosionInteraction.NONE);
        if (state.getBlock().equals(ReactiveBlocks.SHULKER_CRUCIBLE.get())) {
            ItemEntity dropped_shell = new ItemEntity(level, Vec3.atCenterOf((Vec3i)pos).x, Vec3.atCenterOf((Vec3i)pos).y, Vec3.atCenterOf((Vec3i)pos).z, Items.SHULKER_SHELL.getDefaultInstance());
            level.addFreshEntity((Entity)dropped_shell);
        }
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            FlagTrigger.triggerForNearbyPlayers(slevel, (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_CRUCIBLE_FAIL.get()), pos, 24);
        }
        if (((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
            level.setBlock(pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), 2);
        } else {
            level.setBlock(pos, Blocks.CAULDRON.defaultBlockState(), 2);
        }
    }

    public static void empty(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 400) {
            crucible.expendPower((Power)Powers.ASTRAL_POWER.get(), crucible.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) / 2);
            level.setBlock(pos, (BlockState)state.setValue((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(true)), 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
            return;
        }
        if (crucible.getTotalPowerLevel() > 0) {
            SpecialCaseMan.checkEmptySpecialCases(crucible);
            crucible.expendPower();
            crucible.resetColor();
            crucible.setDirty(level, pos, state);
            level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        if (crucible.linked_crystal != null) {
            crucible.unlinkCrystal(level, pos, state);
        }
        crucible.sculkSpreader.clear();
        crucible.reaction_status.clear();
        crucible.reactions_to_render.clear();
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)level.getBlockState(pos)));
    }

    @Override
    public List<ReactionStatusEntry> getReactionStatus() {
        return this.reaction_status;
    }

    @Override
    public void resetReactionStatus() {
        this.reaction_status = new ArrayList<ReactionStatusEntry>();
    }

    @Override
    public boolean hasUsedCrystalThisCycle() {
        return this.used_crystal_this_cycle;
    }

    @Override
    public void setUsedCrystalThisCycle(boolean used) {
        this.used_crystal_this_cycle = used;
    }

    @Override
    public Vec3 getPos() {
        return this.getBlockPos().getBottomCenter().add(0.0, 0.5625, 0.0);
    }

    @Override
    public void unlinkCrystal(Level level, BlockPos pos, BlockState state) {
        this.linked_crystal.setBeamTarget(null);
        this.linked_crystal = null;
        this.setDirty(level, pos, state);
    }

    private static void gatherPower(Level level, CrucibleBlockEntity crucible) {
        if (crucible.areaMemory.exists(level, (Block)ReactiveBlocks.COPPER_SYMBOL.get()) && !crucible.areaMemory.exists(level, (Block)ReactiveBlocks.IRON_SYMBOL.get())) {
            switch (crucible.gather_stage) {
                case 0: {
                    if (!crucible.areaMemory.exists(level, Blocks.NETHER_PORTAL) || crucible.getTotalPowerLevel() <= 400) break;
                    if (crucible.getPowerLevel((Power)Powers.MIND_POWER.get()) > 1300) {
                        BlockPos portal_pos = crucible.areaMemory.fetch(level, Blocks.NETHER_PORTAL);
                        SpecialCaseMan.solidifyPortal(level, portal_pos, (Direction.Axis)level.getBlockState(portal_pos).getValue((Property)NetherPortalBlock.AXIS));
                        level.playSound(null, portal_pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        level.gameEvent((Holder)GameEvent.EXPLODE, crucible.getBlockPos(), GameEvent.Context.of((BlockState)crucible.getBlockState()));
                    }
                    crucible.expendAnyPowerExcept(null, 400);
                    FlagTrigger.triggerForNearbyPlayers((ServerLevel)level, (FlagTrigger)((Object)ReactiveCriterionTriggers.PORTAL_TRADE.get()), crucible.getBlockPos(), (Integer)ConfigMan.COMMON.crucibleRange.get());
                    break;
                }
                case 1: {
                    if (!crucible.areaMemory.exists(level, (Block)ReactiveBlocks.BLAZE_ROD.get())) break;
                    crucible.addPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("blaze_rod_power_amount", 35, 50));
                    FlagTrigger.triggerForNearbyPlayers((ServerLevel)level, (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_BLAZE_GATHER.get()), crucible.getBlockPos(), (Integer)ConfigMan.COMMON.crucibleRange.get());
                    break;
                }
                case 2: {
                    if (!crucible.areaMemory.exists(level, Blocks.END_ROD)) break;
                    crucible.addPower((Power)Powers.LIGHT_POWER.get(), WorldSpecificValue.get("end_rod_power_amount", 100, 300));
                    break;
                }
                case 3: {
                    if (crucible.areaMemory.exists(level, (Block)ReactiveBlocks.OCCULT_SYMBOL.get()) || crucible.areaMemory.exists(level, Blocks.WITHER_SKELETON_SKULL) || crucible.areaMemory.exists(level, Blocks.WITHER_SKELETON_WALL_SKULL)) {
                        crucible.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("wither_skull_power_amount", 50, 400));
                    }
                    if (!crucible.areaMemory.exists(level, (Block)ReactiveBlocks.DIVINE_SYMBOL.get())) break;
                    crucible.expendPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("divine_cleanse_amount", 200, 400));
                    break;
                }
                case 4: {
                    Optional maybe_conduit;
                    if (!crucible.areaMemory.exists(level, Blocks.CONDUIT) || !(maybe_conduit = level.getBlockEntity(crucible.areaMemory.fetch(level, Blocks.CONDUIT), BlockEntityType.CONDUIT)).isPresent() || !((ConduitBlockEntity)maybe_conduit.get()).isActive()) break;
                    if (WorldSpecificValues.CONDUIT_POWER.get() == 1) {
                        crucible.addPower((Power)Powers.SOUL_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                        break;
                    }
                    crucible.addPower((Power)Powers.WARP_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                    break;
                }
                case 5: {
                    if (crucible.enderRiftStrength > 0) {
                        crucible.addPower((Power)Powers.WARP_POWER.get(), 10);
                    }
                    crucible.gather_stage = -1;
                }
            }
            ++crucible.gather_stage;
        }
        if (level.canSeeSky(crucible.getBlockPos())) {
            if (level.isRainingAt(crucible.getBlockPos())) {
                crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), 80);
            } else if (level.getDayTime() > 5900L && level.getDayTime() < 6100L) {
                crucible.addPower((Power)Powers.LIGHT_POWER.get(), 5);
                ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.END_ROD, crucible.getBlockPos(), crucible.getBlockPos().above(15), 5, 0.0);
            }
        }
    }

    private static boolean processItemsInside(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (!((Boolean)state.getValue((Property)CrucibleBlock.FULL)).booleanValue()) {
            return false;
        }
        boolean changed = false;
        for (Entity entity_inside : CrucibleBlock.getEntitesInside(pos, level)) {
            if (!(entity_inside instanceof ItemEntity)) continue;
            ItemEntity item_entity = (ItemEntity)entity_inside;
            SpecialCaseMan.checkDissolveSpecialCases(crucible, item_entity);
            CrucibleBlockEntity.insertPowerBottle(crucible, new PowerBottleInsertContext(item_entity));
            if (!item_entity.isAlive()) continue;
            changed = changed || CrucibleBlockEntity.tryTransmute(level, pos, state, crucible, item_entity);
            boolean bl = changed = changed || CrucibleBlockEntity.tryReduceToPower(item_entity.getItem(), crucible);
            if (item_entity.getItem().getCount() != 0) continue;
            item_entity.remove(Entity.RemovalReason.KILLED);
        }
        changed = changed || CrucibleBlockEntity.tryPrecipitate(level, pos, state, crucible);
        return changed;
    }

    public static boolean tryReduceToPower(ItemStack stack, CrucibleBlockEntity crucible) {
        List<Power> stack_power_list = Power.getSourcePower(stack);
        boolean changed = false;
        if (stack_power_list.isEmpty()) {
            boolean dissolved = CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.getLevel()), crucible.getBlockPos(), stack, stack.getCount(), crucible);
            if (dissolved) {
                stack.setCount(0);
            }
            return false;
        }
        for (Power p : stack_power_list) {
            int dissolve_capacity = (1600 - crucible.getPowerLevel(p)) / Power.getSourceLevel(stack);
            if (dissolve_capacity <= 0) continue;
            changed = changed || crucible.addPower(p, stack.getCount() * Power.getSourceLevel(stack) / stack_power_list.size());
            CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.getLevel()), crucible.getBlockPos(), stack, Math.min(stack.getCount(), dissolve_capacity), crucible);
            stack.setCount(Math.max(stack.getCount() - dissolve_capacity, 0));
        }
        return changed;
    }

    private static boolean tryDissolveWithByproduct(Level level, BlockPos pos, ItemStack stack, int count, CrucibleBlockEntity crucible) {
        List purify_recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ReactiveRecipes.DISSOLVE_RECIPE_TYPE.get());
        for (RecipeHolder holder : purify_recipes) {
            DissolveRecipe recipe = (DissolveRecipe)holder.value();
            if (recipe.needs_electricity && crucible.electricCharge < 1 || !recipe.matches(CrucibleRecipeInput.of(stack), level)) continue;
            ItemStack reactant = stack.copy();
            reactant.setCount(count);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, recipe.assemble(CrucibleRecipeInput.of(reactant), (HolderLookup.Provider)level.registryAccess())));
            return true;
        }
        return false;
    }

    private static boolean tryTransmute(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible, ItemEntity itemEntity) {
        List purify_recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ReactiveRecipes.TRANS_RECIPE_TYPE.get());
        for (RecipeHolder holder : purify_recipes) {
            TransmuteRecipe recipe = (TransmuteRecipe)holder.value();
            if (recipe.needs_electricity && crucible.electricCharge < 1 || !recipe.matches(CrucibleRecipeInput.of(itemEntity.getItem(), crucible.getPowerMap()), level)) continue;
            ItemStack result = recipe.apply(itemEntity.getItem(), crucible);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    private static boolean tryPrecipitate(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        List creation_recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ReactiveRecipes.PRECIPITATE_RECIPE_TYPE.get());
        for (RecipeHolder holder : creation_recipes) {
            PrecipitateRecipe recipe = (PrecipitateRecipe)holder.value();
            if (recipe.needs_electricity && crucible.electricCharge < 1 || !recipe.matches(CrucibleRecipeInput.of(crucible.getPowerMap()), level)) continue;
            ItemStack result = recipe.apply(crucible);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    @Override
    public void setDirty() {
        this.setDirty(Objects.requireNonNull(this.getLevel()), this.getBlockPos(), this.getBlockState());
    }

    public void beHitByLightning() {
        this.electricCharge = 50;
        this.setDirty();
    }

    public void setRemoved() {
        NeoForge.EVENT_BUS.unregister((Object)this);
        super.setRemoved();
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (this.getLevel() == null || !((Boolean)this.getBlockState().getValue((Property)CrucibleBlock.FULL)).booleanValue() || event.getEntity().level().isClientSide || Objects.requireNonNull(this.getLevel()).isClientSide) {
            return;
        }
        LivingEntity entity = event.getEntity();
        double dist = BeamHelper.distance(event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ());
        if (dist > (double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue() || this.areaMemory.exists(event.getEntity().level(), (Block)ReactiveBlocks.IRON_SYMBOL.get())) {
            return;
        }
        if (entity.getTags().contains("reactive:sacrifice_drained")) {
            return;
        }
        event.getEntity().addTag("reactive:sacrifice_drained");
        if (event.getEntity().isInvertedHealAndHarm()) {
            if (!event.getSource().is(DamageTypes.ON_FIRE) && !event.getSource().is(DamageTypes.IN_FIRE)) {
                this.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("undead_curse_strength", 60, 300));
            }
            return;
        }
        FlagTrigger.triggerForNearbyPlayers((ServerLevel)event.getEntity().level(), (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_SACRIFICE.get()), this.getBlockPos(), 8);
        double x = event.getEntity().getX();
        double y = event.getEntity().getY();
        double z = event.getEntity().getZ();
        if (this.getPowerLevel((Power)Powers.CURSE_POWER.get()) >= WorldSpecificValues.CURSE_RATE.get() && this.getPowerLevel((Power)Powers.MIND_POWER.get()) > 0 && !(event.getEntity() instanceof Phantom) && event.getEntity().level().isNight()) {
            this.spawnPhantom(x, y, z);
        } else {
            ParticleScribe.drawParticleLine(this.level, (ParticleOptions)ParticleTypes.CLOUD, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.4, (double)this.getBlockPos().getZ() + 0.5, x, y, z, 15, 0.3);
        }
        int best_sacrifice_type = WorldSpecificValues.BEST_SACRIFICE.get();
        int power = best_sacrifice_type == 1 && event.getEntity() instanceof Animal ? WorldSpecificValue.get("strong_sacrifice", 200, 400) : (best_sacrifice_type == 2 && event.getEntity() instanceof AbstractVillager ? WorldSpecificValue.get("strong_sacrifice", 400, 500) : (best_sacrifice_type == 3 && (event.getEntity() instanceof AbstractPiglin || event.getEntity() instanceof Hoglin) ? WorldSpecificValue.get("strong_sacrifice", 450, 500) : (best_sacrifice_type == 4 && event.getEntity() instanceof Monster ? WorldSpecificValue.get("strong_sacrifice", 200, 600) : WorldSpecificValue.get("weak_sacrifice_" + event.getEntity().getEncodeId(), 60, 120))));
        this.addPower((Power)Powers.VITAL_POWER.get(), power);
        this.setDirty();
    }

    private void spawnPhantom(double x, double y, double z) {
        Phantom p = new Phantom(EntityType.PHANTOM, Objects.requireNonNull(this.getLevel()));
        p.setPos(new Vec3(x, y + 2.0, z));
        p.setPhantomSize(this.getLevel().random.nextInt(2, 4));
        assert (this.getLevel() != null);
        this.getLevel().addFreshEntity((Entity)p);
        ParticleScribe.drawParticleLine(this.level, (ParticleOptions)ParticleTypes.SMOKE, x, y, z, x, y + 2.0, z, 25, 0.1);
    }

    @Override
    @NotNull
    public Map<Power, Integer> getPowerMap() {
        return this.powers;
    }

    @Override
    public boolean areReactionsPaused() {
        return this.reactions_paused;
    }

    @Override
    public ReactionStatusPayload getPayload() {
        return new ReactionStatusPayload(new ArrayList<ReactionStatusEntry>(this.getReactionStatus()), new ReactionStatusPayload.Target((Either<BlockPos, Integer>)Either.left((Object)this.getBlockPos())));
    }

    public static void insertPowerBottle(CrucibleBlockEntity crucible, PowerBottleInsertContext context) {
        boolean changed = false;
        for (Power p : (Registry)Powers.POWERS.getRegistry().get()) {
            if (!p.matchesBottle(context.getBottle()) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
            if (context.getBottle().is((Item)ReactiveItems.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(context.getBottle())) {
                crucible.enderRiftStrength = 2000;
            }
            context.reduceByOne();
            changed = true;
        }
        if (changed) {
            crucible.setDirty();
            assert (crucible.getLevel() != null);
            crucible.getLevel().playSound(null, crucible.getBlockPos(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.getLevel().getRandom().nextFloat() / 5.0f);
            crucible.getLevel().gameEvent((Holder)GameEvent.FLUID_PICKUP, crucible.getBlockPos(), GameEvent.Context.of((BlockState)crucible.getBlockState()));
        }
    }

    public void setDirty(Level level, BlockPos pos, BlockState state) {
        if (!level.isClientSide) {
            this.setChanged();
            level.sendBlockUpdated(pos, state, state, 2);
        }
    }

    @Override
    public AreaMemory getAreaMemory() {
        return this.areaMemory;
    }

    @Override
    public int getElectricCharge() {
        return this.electricCharge;
    }

    @Override
    public EndCrystal getLinkedCrystal() {
        return this.linked_crystal;
    }

    @Override
    public void setLinkedCrystal(EndCrystal end_crystal) {
        this.linked_crystal = end_crystal;
    }

    public List<String> getRenderReactions() {
        return this.reactions_to_render;
    }

    @Override
    public void setElectricCharge(int i) {
        this.electricCharge = i;
    }

    @Override
    public void clearRenderReactions() {
        this.reactions_to_render.clear();
    }

    @Override
    public void addRenderReaction(String s) {
        this.reactions_to_render.add(s);
    }

    @Override
    public void expendPower() {
        this.getPowerMap().clear();
        this.color_changed = true;
        this.mix_color.reset();
        this.next_mix_color.reset();
        this.color_initialized = false;
    }

    @Override
    public int maxPower() {
        return 1600;
    }

    public void setStartingColor(Color starting) {
        this.mix_color.set(starting);
        this.color_initialized = true;
    }

    public Color getCombinedColor(int water_color_number) {
        Color water_color = new Color(water_color_number);
        if (this.powers == null || this.powers.isEmpty() || this.getTotalPowerLevel() == 0) {
            return water_color;
        }
        if (this.color_changed) {
            this.updateColor(water_color);
        }
        if (!this.color_initialized) {
            this.mix_color.set(water_color);
            this.color_initialized = true;
        }
        if (!this.mix_color.equals(this.next_mix_color)) {
            int delta_red = Math.min(Math.abs(this.next_mix_color.red - this.mix_color.red), 2);
            int delta_green = Math.min(Math.abs(this.next_mix_color.green - this.mix_color.green), 2);
            int delta_blue = Math.min(Math.abs(this.next_mix_color.blue - this.mix_color.blue), 2);
            this.mix_color.red = this.next_mix_color.red > this.mix_color.red ? this.mix_color.red + delta_red : this.mix_color.red - delta_red;
            this.mix_color.green = this.next_mix_color.green > this.mix_color.green ? this.mix_color.green + delta_green : this.mix_color.green - delta_green;
            this.mix_color.blue = this.next_mix_color.blue > this.mix_color.blue ? this.mix_color.blue + delta_blue : this.mix_color.blue - delta_blue;
        }
        return this.mix_color;
    }

    private void updateColor(Color water_color) {
        if (this.powers == null) {
            return;
        }
        this.next_mix_color.reset();
        this.next_mix_color.setMixColor(water_color, this.getPowerMap(), this.getTotalVisiblePowerLevel(), this.maxPower());
        this.color_changed = false;
    }

    private int getTotalVisiblePowerLevel() {
        int totalpp = 0;
        for (Power p : this.powers.keySet()) {
            if (p.invisible) continue;
            totalpp += this.powers.get(p).intValue();
        }
        return totalpp;
    }

    private void resetColor() {
        this.color_changed = true;
        this.color_initialized = false;
        this.mix_color.reset();
        this.next_mix_color.reset();
    }

    public float getOpacity() {
        return 0.7f + 0.3f * (float)this.getTotalVisiblePowerLevel() / 1600.0f;
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        super.onDataPacket(net, pkt, registries);
        this.color_changed = true;
    }

    protected void saveAdditional(@NotNull CompoundTag main_tag, HolderLookup.Provider provider) {
        super.saveAdditional(main_tag, provider);
        main_tag.put("electric_charge", (Tag)IntTag.valueOf((int)this.electricCharge));
        main_tag.put("integrity", (Tag)IntTag.valueOf((int)this.integrity));
        if (this.linked_crystal != null) {
            main_tag.put("LinkedCrystal", (Tag)NbtUtils.createUUID((UUID)this.linked_crystal.getUUID()));
        }
        if (this.powers.isEmpty()) {
            return;
        }
        ListTag power_list_tag = new ListTag();
        for (Power p : this.powers.keySet()) {
            if (p == null) {
                System.err.println("Skipping null power in save process.");
                continue;
            }
            CompoundTag tag = new CompoundTag();
            tag.put("name", (Tag)StringTag.valueOf((String)p.getResourceLocation().toString()));
            tag.put("level", (Tag)IntTag.valueOf((int)this.getPowerLevel(p)));
            power_list_tag.add((Object)tag);
        }
        main_tag.put("powers", (Tag)power_list_tag);
        this.sculkSpreader.save(main_tag);
    }

    public void loadAdditional(@NotNull CompoundTag main_tag, HolderLookup.Provider provider) {
        Object object;
        super.loadAdditional(main_tag, provider);
        if (main_tag.contains("LinkedCrystal") && (object = this.getLevel()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)object;
            UUID crystal_uuid = main_tag.getUUID("LinkedCrystal");
            Entity entity = server.getEntity(crystal_uuid);
            if (entity instanceof EndCrystal) {
                EndCrystal crystal;
                this.linked_crystal = crystal = (EndCrystal)entity;
            }
        } else {
            this.linked_crystal = null;
        }
        ListTag power_list_tag = (ListTag)main_tag.get("powers");
        this.powers.clear();
        if (power_list_tag != null && !power_list_tag.isEmpty()) {
            for (Tag power_tag : power_list_tag) {
                Power p = Power.readPower((CompoundTag)power_tag);
                this.addPower(p, ((CompoundTag)power_tag).getInt("level"));
            }
        } else {
            this.resetColor();
        }
        this.electricCharge = main_tag.getInt("electric_charge");
        if (main_tag.contains("integrity")) {
            this.integrity = main_tag.getInt("integrity");
        }
        this.sculkSpreader.load(main_tag);
    }
}

