/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.blocks.ActiveGoldFoamBlock;
import dev.hyperlynx.reactive.blocks.GoldFoamBlock;
import dev.hyperlynx.reactive.registration.ReactiveBlockEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ActiveFoamBlockEntity
extends BlockEntity {
    int spreads_left = 16;
    int tick_counter = 0;

    public ActiveFoamBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ReactiveBlockEntityTypes.ACTIVE_GOLD_FOAM.get(), pos, state);
    }

    private static void trySpread(Level level, BlockPos target, BlockPos spreader, int spreads_left) {
        if (level.getBlockState(target).isAir() || level.getBlockState(target).is((Block)ReactiveBlocks.GOLD_FOAM.get())) {
            if (level.getBlockEntity(spreader) == null) {
                return;
            }
            level.setBlock(target, ((ActiveGoldFoamBlock)((Object)ReactiveBlocks.ACTIVE_GOLD_FOAM.get())).defaultBlockState(), 2);
            ((ActiveFoamBlockEntity)Objects.requireNonNull(level.getBlockEntity((BlockPos)target))).spreads_left = spreads_left - 1;
            level.setBlock(spreader, ((GoldFoamBlock)((Object)ReactiveBlocks.GOLD_FOAM.get())).defaultBlockState(), 2);
            level.playSound(null, target, SoundEvents.WOOL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void trySpreadInert(Level level, BlockPos pos) {
        if (level.getBlockState(pos).isAir()) {
            level.setBlock(pos, ((GoldFoamBlock)((Object)ReactiveBlocks.GOLD_FOAM.get())).defaultBlockState(), 2);
            level.playSound(null, pos, SoundEvents.WOOL_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void trySpreadSideways(Level level, BlockPos pos, RandomSource random, int spreads_left) {
        int forbidden_direction;
        int active_direction = random.nextIntBetweenInclusive(1, 4);
        if (active_direction == (forbidden_direction = WorldSpecificValue.get("gold_foam_spread_direction", 1, 4))) {
            return;
        }
        if (active_direction == 1) {
            ActiveFoamBlockEntity.trySpread(level, pos.east(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.west());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.north());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.south());
        } else if (active_direction == 2) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.east());
            ActiveFoamBlockEntity.trySpread(level, pos.west(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.north());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.south());
        } else if (active_direction == 3) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.east());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.west());
            ActiveFoamBlockEntity.trySpread(level, pos.north(), pos, spreads_left);
            ActiveFoamBlockEntity.trySpreadInert(level, pos.south());
        } else if (active_direction == 4) {
            ActiveFoamBlockEntity.trySpreadInert(level, pos.east());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.west());
            ActiveFoamBlockEntity.trySpreadInert(level, pos.north());
            ActiveFoamBlockEntity.trySpread(level, pos.south(), pos, spreads_left);
        }
    }

    public static void tick(Level level, BlockPos pos, ActiveFoamBlockEntity foam) {
        if (level.isClientSide) {
            return;
        }
        ++foam.tick_counter;
        if (foam.tick_counter > 5) {
            foam.tick_counter = 0;
            if (foam.spreads_left == 0) {
                level.setBlock(pos, ((GoldFoamBlock)((Object)ReactiveBlocks.GOLD_FOAM.get())).defaultBlockState(), 2);
                return;
            }
            ActiveFoamBlockEntity.spreadAround(level, pos, level.random, foam.spreads_left);
        }
    }

    public static void spreadAround(Level level, BlockPos pos, RandomSource random, int spreads_left) {
        float up_chance = WorldSpecificValue.get("gold_foam_up_chance", 0.2f, 0.5f);
        float down_chance = WorldSpecificValue.get("gold_foam_down_chance", 0.2f, 0.5f);
        if (WorldSpecificValue.getBool("gold_foam_up_priority", 0.5f)) {
            if (random.nextFloat() < up_chance) {
                ActiveFoamBlockEntity.trySpread(level, pos.above(), pos, spreads_left);
            } else if (random.nextFloat() < down_chance) {
                ActiveFoamBlockEntity.trySpread(level, pos.below(), pos, spreads_left);
            } else {
                ActiveFoamBlockEntity.trySpreadSideways(level, pos, random, spreads_left);
            }
        } else if (random.nextFloat() < down_chance) {
            ActiveFoamBlockEntity.trySpread(level, pos.below(), pos, spreads_left);
        } else if (random.nextFloat() < up_chance) {
            ActiveFoamBlockEntity.trySpread(level, pos.above(), pos, spreads_left);
        } else {
            ActiveFoamBlockEntity.trySpreadSideways(level, pos, random, spreads_left);
        }
    }
}

