/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.special;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.special.BottleSpecialCase;
import dev.hyperlynx.reactive.alchemy.special.DissolveEvent;
import dev.hyperlynx.reactive.alchemy.special.DissolveSpecialCase;
import dev.hyperlynx.reactive.alchemy.special.EmptyEvent;
import dev.hyperlynx.reactive.alchemy.special.EmptySpecialCase;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.AirLightBlock;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import dev.hyperlynx.reactive.blocks.IncompleteStaffBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.entites.ReactorEntity;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.LitmusPaperItem;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveComponentTypes;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import dev.hyperlynx.reactive.registration.ReactiveEntityTypes;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.util.HyperPortalShape;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;

public class SpecialCaseMan {
    public static final List<DissolveSpecialCase> DISSOLVE_SPECIAL_CASES = new ArrayList<DissolveSpecialCase>();
    public static final List<EmptySpecialCase> EMPTY_SPECIAL_CASES = new ArrayList<EmptySpecialCase>();
    public static final List<BottleSpecialCase> EXTRACT_BOTTLE_SPECIAL_CASES = new ArrayList<BottleSpecialCase>();
    private static final int MATERIAL_CRAFT_MIN_POWER = 800;

    public static void checkDissolveSpecialCases(CrucibleBlockEntity c, ItemEntity e) {
        NeoForge.EVENT_BUS.post((Event)new DissolveEvent(e, c));
        for (DissolveSpecialCase dissolve_case : DISSOLVE_SPECIAL_CASES) {
            if (dissolve_case.attempt(c, e)) break;
        }
    }

    public static void checkEmptySpecialCases(CrucibleBlockEntity c) {
        NeoForge.EVENT_BUS.post((Event)new EmptyEvent(c));
        if (c.getLevel() == null) {
            return;
        }
        for (EmptySpecialCase empty_case : EMPTY_SPECIAL_CASES) {
            empty_case.attempt(c);
        }
    }

    public static ItemStack checkBottleSpecialCases(CrucibleBlockEntity c, ItemStack b) {
        ItemStack bottle = b.copy();
        for (BottleSpecialCase bottle_case : EXTRACT_BOTTLE_SPECIAL_CASES) {
            bottle = bottle_case.attempt(c, bottle);
        }
        return bottle;
    }

    public static void bootstrap() {
        SpecialCaseMan.register_dissolve_cases();
        SpecialCaseMan.register_empty_cases();
        SpecialCaseMan.register_bottle_cases();
    }

    public static void register_dissolve_cases() {
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is((Item)ReactiveItems.LITMUS_PAPER.get())) {
                LitmusPaperItem.takeMeasurement(e.getItem(), c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Tags.Items.ENDER_PEARLS)) {
                SpecialCaseMan.enderPearlDissolve(Objects.requireNonNull(c.getLevel()), c.getBlockPos(), e, c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Tags.Items.GUNPOWDERS) && c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > 10) {
                SpecialCaseMan.explodeGunpowderDueToBlaze(Objects.requireNonNull(c.getLevel()), c.getBlockPos(), e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Items.CARVED_PUMPKIN)) {
                SpecialCaseMan.pumpkinMagic(Objects.requireNonNull(c.getLevel()), e, c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Items.WRITABLE_BOOK)) {
                SpecialCaseMan.waterWriting(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Tags.Items.INGOTS_COPPER) && c.getPowerLevel((Power)Powers.ACID_POWER.get()) > 10) {
                SpecialCaseMan.copperCharging(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Items.ENDER_EYE) && c.getPowerLevel((Power)Powers.CURSE_POWER.get()) < 10) {
                SpecialCaseMan.enderEyeFlyAway(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is((Item)ReactiveItems.PHANTOM_RESIDUE.get()) && c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > 700) {
                SpecialCaseMan.residualSlime(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is(Items.SCULK_CATALYST)) {
                SpecialCaseMan.sculkMagic(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if ((e.getItem().is((Item)ReactiveItems.MOTION_SALT_BLOCK.get()) || e.getItem().is((Item)ReactiveItems.FRAMED_MOTION_SALT_BLOCK.get())) && c.electricCharge > 0) {
                SpecialCaseMan.displaceNearby(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is((Item)ReactiveItems.INERT_CRYSTAL.get())) {
                SpecialCaseMan.preventReactions(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().is((Item)ReactiveItems.GOLD_THREAD.get())) {
                SpecialCaseMan.expelReaction(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.getItem().getItemHolder().getData(ReactiveDataMaps.MATERIAL_SALT_YIELDS) != null) {
                SpecialCaseMan.saltMaterialCraft(c, e);
                return true;
            }
            return false;
        });
    }

    public static void register_empty_cases() {
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > WorldSpecificValue.get("soul_escape_threshold", 300, 600)) {
                SpecialCaseMan.soulEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 665) {
                SpecialCaseMan.curseEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > WorldSpecificValue.get("blaze_escape_threshold", 20, 100)) {
                SpecialCaseMan.blazeEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > WorldSpecificValue.get("verdant_escape_threshold", 1300, 1500)) {
                SpecialCaseMan.verdantEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.LIGHT_POWER.get()) > WorldSpecificValue.get("light_escape_threshold", 800, 1100)) {
                SpecialCaseMan.lightEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.FLOW_POWER.get()) > 0) {
                SpecialCaseMan.windBomb(c.getLevel(), Vec3.atCenterOf((Vec3i)c.getBlockPos()));
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.OMEN_POWER.get()) > 121) {
                SpecialCaseMan.badOmen(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.areaMemory.exists(c.getLevel(), (Block)ReactiveBlocks.INCOMPLETE_STAFF.get())) {
                IncompleteStaffBlock.staffCraftStep(c, c.areaMemory.fetch(c.getLevel(), (Block)ReactiveBlocks.INCOMPLETE_STAFF.get()));
            }
        });
    }

    public static void register_bottle_cases() {
        EXTRACT_BOTTLE_SPECIAL_CASES.add((c, bottle) -> {
            if (c.enderRiftStrength > 0 && bottle.is((Item)ReactiveItems.WARP_BOTTLE.get())) {
                return WarpBottleItem.makeRiftBottle(c, bottle);
            }
            return bottle;
        });
    }

    private static void copperCharging(CrucibleBlockEntity c) {
        if (c.electricCharge < 20) {
            c.electricCharge += 2;
        }
    }

    private static void enderEyeFlyAway(CrucibleBlockEntity c, ItemEntity e) {
        ServerLevel serverlevel = (ServerLevel)c.getLevel();
        if (serverlevel == null) {
            return;
        }
        BlockPos blockpos = serverlevel.findNearestMapStructure(StructureTags.EYE_OF_ENDER_LOCATED, c.getBlockPos(), 100, false);
        if (blockpos != null) {
            EyeOfEnder eyeofender = new EyeOfEnder(c.getLevel(), (double)c.getBlockPos().getX(), (double)c.getBlockPos().getY(), (double)c.getBlockPos().getZ());
            eyeofender.setItem(e.getItem());
            eyeofender.signalTo(blockpos);
            c.getLevel().addFreshEntity((Entity)eyeofender);
            c.getLevel().playSound(null, (double)c.getBlockPos().getX() + 0.5, (double)c.getBlockPos().getY() + 0.5, (double)c.getBlockPos().getZ() + 0.5, SoundEvents.ENDER_EYE_LAUNCH, SoundSource.NEUTRAL, 0.5f, 0.4f / (c.getLevel().getRandom().nextFloat() * 0.4f + 0.8f));
            e.getItem().shrink(1);
            if (e.getItem().getCount() < 1) {
                e.kill();
            }
        }
    }

    private static void pumpkinMagic(Level level, ItemEntity e, CrucibleBlockEntity c) {
        if (level.isClientSide || c.areaMemory.exists(level, (Block)ReactiveBlocks.IRON_SYMBOL.get())) {
            return;
        }
        BlockPos blazeRodPos = c.areaMemory.fetch(level, (Block)ReactiveBlocks.BLAZE_ROD.get());
        if (blazeRodPos != null && c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > 0) {
            SpecialCaseMan.conjureBlaze(level, e, c, blazeRodPos);
            return;
        }
        if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) == 0) {
            return;
        }
        int cause = WorldSpecificValues.GOLEM_CAUSE.get();
        BlockPos candlePos = c.areaMemory.fetch(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (TagKey<Block>)BlockTags.CANDLES);
        if (candlePos != null && ((Boolean)level.getBlockState(candlePos).getValue((Property)CandleBlock.LIT)).booleanValue()) {
            SpecialCaseMan.conjureSpirit(level, e, c, cause, candlePos);
        }
    }

    private static void sculkMagic(CrucibleBlockEntity c) {
        if (!(c.getLevel() instanceof ServerLevel)) {
            return;
        }
        int spread = WorldSpecificValue.get("sculk_spread_amount", 12, 20);
        if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 800) {
            c.sculkSpreader.addCursors(c.getBlockPos().north(), spread);
            c.sculkSpreader.addCursors(c.getBlockPos().south(), spread);
            c.sculkSpreader.addCursors(c.getBlockPos().east(), spread);
            c.sculkSpreader.addCursors(c.getBlockPos().west(), spread);
            c.expendPower((Power)Powers.SOUL_POWER.get(), 500);
        } else if (c.getPowerLevel((Power)Powers.VITAL_POWER.get()) > 100) {
            c.expendPower((Power)Powers.VITAL_POWER.get(), 100);
            c.addPower((Power)Powers.SOUL_POWER.get(), WorldSpecificValue.get("sculk_soul_return", 60, 100));
        }
    }

    private static void conjureBlaze(Level level, ItemEntity e, CrucibleBlockEntity c, BlockPos blazeRodPos) {
        c.addPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("blaze_conjure_yield", 200, 400));
        EntityType.BLAZE.spawn((ServerLevel)level, null, null, blazeRodPos, MobSpawnType.MOB_SUMMONED, true, true);
        e.kill();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.FLAME, (double)c.getBlockPos().getX() + 0.5, (double)c.getBlockPos().getY() + 0.5125, (double)c.getBlockPos().getZ() + 0.5, (double)blazeRodPos.getX() + 0.5, (double)blazeRodPos.getY() + 0.38, (double)blazeRodPos.getZ() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)blazeRodPos.getX() + 0.5, (double)blazeRodPos.getY() + 0.38, (double)blazeRodPos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.playSound(null, blazeRodPos, SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void conjureSpirit(Level level, ItemEntity e, CrucibleBlockEntity c, int cause, BlockPos candlePos) {
        if (cause == 1) {
            if ((double)level.random.nextFloat() > 0.07 && c.getPowerLevel((Power)Powers.CURSE_POWER.get()) <= 20) {
                EntityType.ALLAY.spawn((ServerLevel)level, null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
                var6_5 = e.getOwner();
                if (var6_5 instanceof ServerPlayer) {
                    player = (ServerPlayer)var6_5;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_ALLAY_SUMMON.get())).trigger(player);
                }
            } else {
                EntityType.VEX.spawn((ServerLevel)level, null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
            }
        } else if (cause == 2) {
            if ((double)level.random.nextFloat() > 0.07 && c.getPowerLevel((Power)Powers.MIND_POWER.get()) <= 20) {
                EntityType.VEX.spawn((ServerLevel)level, null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
            } else {
                EntityType.ALLAY.spawn((ServerLevel)level, null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
                var6_5 = e.getOwner();
                if (var6_5 instanceof ServerPlayer) {
                    player = (ServerPlayer)var6_5;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_ALLAY_SUMMON.get())).trigger(player);
                }
            }
        }
        e.kill();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.ENCHANTED_HIT, (double)c.getBlockPos().getX() + 0.5, (double)c.getBlockPos().getY() + 0.5125, (double)c.getBlockPos().getZ() + 0.5, (double)candlePos.getX() + 0.5, (double)candlePos.getY() + 0.38, (double)candlePos.getZ() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.POOF, (double)candlePos.getX() + 0.5, (double)candlePos.getY() + 0.38, (double)candlePos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.playSound(null, candlePos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void enderPearlDissolve(Level l, BlockPos p, ItemEntity e, CrucibleBlockEntity c) {
        float chance = (float)c.getPowerLevel((Power)Powers.WARP_POWER.get()) / 1600.0f;
        if (l.random.nextFloat() > chance) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ((ServerLevel)l).sendParticles((ParticleOptions)ParticleTypes.PORTAL, e.getX(), e.getY() + l.random.nextDouble() * 2.0, e.getZ(), 1, l.random.nextGaussian(), 0.0, l.random.nextGaussian(), 0.0);
        }
        boolean foundTarget = false;
        Entity thrower = e.getOwner();
        if (thrower != null) {
            Player player = l.getPlayerByUUID(thrower.getUUID());
            if (!l.isClientSide) {
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.ENDER_PEARL_DISSOLVE.get())).trigger((ServerPlayer)player);
            }
            if (player != null && e.level().dimension().equals(player.level().dimension())) {
                player.teleportTo((double)p.getX() + 0.5, (double)p.getY() + 0.85, (double)p.getZ() + 0.5);
                foundTarget = true;
            }
        }
        if (!foundTarget) {
            FlagTrigger.triggerForNearbyPlayers((ServerLevel)l, (FlagTrigger)((Object)ReactiveCriterionTriggers.MAKE_RIFT.get()), p, 20);
            c.enderRiftStrength = 2000;
        }
        e.kill();
    }

    public static boolean tryTeleportNearbyEntity(BlockPos pos, Level level, BlockPos destination, boolean can_teleport_players) {
        AABB aoe = new AABB(pos);
        aoe = aoe.inflate((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
        List nearby_ents = Objects.requireNonNull(level).getEntitiesOfClass(LivingEntity.class, aoe);
        ArrayList<LivingEntity> to_be_excluded = new ArrayList<LivingEntity>();
        for (LivingEntity e : nearby_ents) {
            if (((List)ConfigMan.COMMON.doNotTeleport.get()).contains(e.getEncodeId())) {
                to_be_excluded.add(e);
                continue;
            }
            if (e instanceof Player && !can_teleport_players) {
                to_be_excluded.add(e);
                continue;
            }
            if (CrystalIronItem.effectNotBlocked(e, (double)level.random.nextFloat() < 0.02 ? 1 : 0)) continue;
            to_be_excluded.add(e);
        }
        nearby_ents.removeAll(to_be_excluded);
        if (nearby_ents.isEmpty()) {
            return false;
        }
        LivingEntity victim = (LivingEntity)nearby_ents.getFirst();
        for (LivingEntity e : nearby_ents) {
            if (!(e.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < victim.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)))) continue;
            victim = e;
        }
        victim.teleportTo((double)destination.getX() + 0.5, (double)destination.getY() + 0.85, (double)destination.getZ() + 0.5);
        return true;
    }

    private static void explodeGunpowderDueToBlaze(Level l, BlockPos p, ItemEntity e) {
        l.explode((Entity)e, (double)p.getX() + 0.5, (double)p.getY() + 0.5, (double)p.getZ() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
        e.kill();
    }

    private static void waterWriting(CrucibleBlockEntity c, ItemEntity e) {
        int low = WorldSpecificValue.get("water_write_low_threshold", 200, 400);
        int high = WorldSpecificValue.get("water_write_high_threshold", 500, 800);
        if (c.getPowerLevel((Power)Powers.MIND_POWER.get()) < low) {
            boolean harvested = SpecialCaseMan.lowWaterWriting(c, e, low);
            if (harvested) {
                e.level().playSound(null, c.getBlockPos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
                e.level().playSound(null, c.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.6f, 0.6f);
            }
        } else if (c.getPowerLevel((Power)Powers.MIND_POWER.get()) > high) {
            SpecialCaseMan.highWaterWriting(c, e, high);
            e.level().playSound(null, c.getBlockPos(), SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, 1.0f);
            e.level().playSound(null, c.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.7f, 0.7f);
        }
    }

    private static Filterable<String> literalFilteredString(String str) {
        return Filterable.from((FilteredText)FilteredText.passThrough((String)str));
    }

    private static void highWaterWriting(CrucibleBlockEntity c, ItemEntity e, int threshold) {
        ArrayList<Filterable<String>> pages;
        String CHAR_LIST = "abcdefhijklmnopqstuvwxyz, -;6'";
        WritableBookContent book_content = (WritableBookContent)e.getItem().get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (book_content == null) {
            book_content = new WritableBookContent(new ArrayList());
        }
        if ((pages = new ArrayList<Filterable<String>>(book_content.pages())).isEmpty() || e.level().random.nextFloat() < 0.5f && pages.size() < 40) {
            pages.add(SpecialCaseMan.literalFilteredString(""));
        }
        for (int page_index = 0; page_index < pages.size() && c.getPowerLevel((Power)Powers.MIND_POWER.get()) >= threshold; ++page_index) {
            ArrayList<String> words = new ArrayList<String>(List.of(((String)((Filterable)pages.get(page_index)).raw()).split("\\s+")));
            if (words.isEmpty() || e.level().random.nextFloat() < 0.1f) {
                if (e.getOwner() != null && page_index == WorldSpecificValue.get("player_name_index", 0, 10)) {
                    words.add(e.getOwner().getName().getString());
                }
                if (page_index == WorldSpecificValue.get("devoid_prayer_index", 10, 40)) {
                    words.addAll(List.of(Component.translatable((String)"text.reactive.devoid").getString().split("\\s+")));
                } else {
                    words.add(WorldSpecificValue.getFromCollection("devoid_word_" + page_index, List.of(Component.translatable((String)"text.reactive.devoid").getString().split("\\s+"))));
                }
            }
            if ((double)e.level().random.nextFloat() < 0.3) {
                StringBuilder chaos = new StringBuilder();
                for (int i = 0; i < e.level().random.nextInt(3, 25); ++i) {
                    chaos.append(CHAR_LIST.charAt(e.level().random.nextInt(CHAR_LIST.length())));
                }
                words.add(e.level().random.nextInt(words.size()), chaos.toString());
            } else {
                int index = e.level().random.nextInt(words.size());
                words.add(index, (String)words.get(index));
            }
            String text = (String)words.stream().reduce((s1, s2) -> s1 + " " + s2).get();
            if (text.length() > 250) {
                text = text.substring(0, 250);
            }
            pages.set(page_index, SpecialCaseMan.literalFilteredString(text));
            c.expendPower((Power)Powers.MIND_POWER.get(), WorldSpecificValue.get("water_write_cost", 10, 20));
        }
        WritableBookContent new_book_content = book_content.withReplacedPages(pages);
        e.getItem().set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new_book_content);
        c.setDirty();
    }

    private static boolean lowWaterWriting(CrucibleBlockEntity c, ItemEntity e, int threshold) {
        WritableBookContent book_content = (WritableBookContent)e.getItem().get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (book_content == null) {
            book_content = new WritableBookContent(new ArrayList());
        }
        boolean did_anything = false;
        ArrayList<Filterable<String>> pages = new ArrayList<Filterable<String>>(book_content.pages());
        for (int page_index = 0; page_index < pages.size() && c.getPowerLevel((Power)Powers.MIND_POWER.get()) <= threshold; ++page_index) {
            ArrayList<String> words = new ArrayList<String>(List.of(((String)((Filterable)pages.get(page_index)).raw()).split("\\s+")));
            if (words.isEmpty()) continue;
            did_anything = true;
            String victim = (String)words.get(e.level().random.nextInt(words.size()));
            String blank = " ".repeat(victim.length());
            pages.set(page_index, SpecialCaseMan.literalFilteredString(((String)((Filterable)pages.get(page_index)).raw()).replace(victim, blank)));
            c.addPower((Power)Powers.MIND_POWER.get(), WorldSpecificValue.get("water_write_cost", 10, 20) - 1);
        }
        c.setDirty();
        if (did_anything) {
            WritableBookContent new_book_content = book_content.withReplacedPages(pages);
            e.getItem().set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new_book_content);
        }
        return did_anything;
    }

    private static void residualSlime(CrucibleBlockEntity c, ItemEntity e) {
        c.expendPower((Power)Powers.VERDANT_POWER.get(), 400);
        c.setDirty();
        if (e.getItem().getCount() == 1) {
            e.kill();
        } else {
            e.getItem().shrink(1);
        }
        Slime slime = new Slime(EntityType.SLIME, Objects.requireNonNull(c.getLevel()));
        slime.setPos(Vec3.atCenterOf((Vec3i)c.getBlockPos()).add(0.0, 0.1, 0.0));
        slime.setSize(1, true);
        c.getLevel().addFreshEntity((Entity)slime);
    }

    private static void displaceNearby(CrucibleBlockEntity c) {
        if (c.getLevel() == null) {
            return;
        }
        Optional target = BlockPos.findClosestMatch((BlockPos)c.getBlockPos(), (int)((Integer)ConfigMan.COMMON.crucibleRange.get()), (int)((Integer)ConfigMan.COMMON.crucibleRange.get()), blockPos -> {
            BlockState state = Objects.requireNonNull(c.getLevel()).getBlockState(blockPos);
            return !blockPos.equals((Object)c.getBlockPos()) && !state.isAir() && !state.is((Block)ReactiveBlocks.VOLT_CELL.get());
        });
        if (target.isPresent()) {
            assert (c.getLevel() != null);
            DisplacedBlock.displace(c.getLevel().getBlockState((BlockPos)target.get()), (BlockPos)target.get(), c.getLevel(), 200);
            for (int i = 0; i < 2; ++i) {
                ParticleScribe.drawParticleZigZag(c.getLevel(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, c.getBlockPos(), (BlockPos)target.get(), 5, 8, 0.9f);
            }
        }
    }

    private static void soulEscape(CrucibleBlockEntity c) {
        if (c.getLevel() == null) {
            return;
        }
        if (c.getLevel().isClientSide()) {
            c.getLevel().addParticle((ParticleOptions)ParticleTypes.SOUL, (double)c.getBlockPos().getX() + 0.5, (double)c.getBlockPos().getY() + 0.65, (double)c.getBlockPos().getZ() + 0.5, 0.0, 0.0, 0.0);
        } else {
            ((ServerLevel)c.getLevel()).sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)c.getBlockPos().getX() + 0.5, (double)c.getBlockPos().getY() + 0.65, (double)c.getBlockPos().getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void curseEscape(CrucibleBlockEntity c) {
        if (c.getLevel() == null) {
            return;
        }
        AABB aoe = new AABB(c.getBlockPos());
        aoe = aoe.inflate(5.0);
        if (!c.getLevel().isClientSide()) {
            if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 1400) {
                Object m = (double)c.getLevel().getRandom().nextFloat() < 0.35 ? new Skeleton(EntityType.SKELETON, c.getLevel()) : new Zombie(EntityType.ZOMBIE, c.getLevel());
                m.setSilent(true);
                m.setPos(aoe.getCenter().add((double)WorldSpecificValue.get("monster_summon_x", -5, 5), 1.0, (double)WorldSpecificValue.get("monster_summon_z", -5, 5)));
                c.getLevel().addFreshEntity((Entity)m);
            }
            List nearby_ents = c.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (e.isInvertedHealAndHarm()) continue;
                e.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 300, 0));
                e.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, 0));
                e.hurt(e.level().damageSources().magic(), 10.0f);
                if (!(e instanceof Player)) continue;
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.BE_CURSED.get())).trigger((ServerPlayer)e);
            }
            c.getLevel().playSound(null, c.getBlockPos(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void blazeEscape(CrucibleBlockEntity c) {
        if (c.getLevel() == null) {
            return;
        }
        AABB blast_zone = new AABB(c.getBlockPos());
        blast_zone.inflate(1.5, 3.0, 1.5);
        if (!c.getLevel().isClientSide()) {
            List nearby_ents = c.getLevel().getEntitiesOfClass(LivingEntity.class, blast_zone);
            for (LivingEntity e : nearby_ents) {
                e.hurt(e.level().damageSources().inFire(), 12.0f);
                e.setRemainingFireTicks(60);
            }
            c.getLevel().playSound(null, c.getBlockPos(), SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
                    ParticleScribe.drawParticleCrucibleTop(c.getLevel(), (ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, c.getBlockPos(), 1.0f, 0.0, 1.0, 0.0);
                    continue;
                }
                ParticleScribe.drawParticleCrucibleTop(c.getLevel(), (ParticleOptions)ParticleTypes.FLAME, c.getBlockPos(), 1.0f, 0.0, 1.0, 0.0);
            }
        }
    }

    private static void verdantEscape(CrucibleBlockEntity c) {
        if (c.getLevel() == null || c.getLevel().isClientSide || WorldSpecificValue.getBool("no_moss", 0.5f)) {
            return;
        }
        ((MossBlock)Blocks.MOSS_BLOCK).performBonemeal((ServerLevel)c.getLevel(), c.getLevel().random, c.getBlockPos().below(), c.getBlockState());
    }

    private static void lightEscape(CrucibleBlockEntity c) {
        if (c.getLevel() == null || c.getLevel().isClientSide || !c.getLevel().getBlockState(c.getBlockPos().above()).isAir()) {
            return;
        }
        c.getLevel().setBlock(c.getBlockPos().above(), ((AirLightBlock)((Object)ReactiveBlocks.GLOWING_AIR.get())).defaultBlockState(), 2);
    }

    public static void windBomb(Level level, Vec3 position) {
        SpecialCaseMan.windBomb(level, position, 1.6f);
    }

    public static void windBomb(Level level, Vec3 position, float radius) {
        if (level == null) {
            return;
        }
        level.explode(null, null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, position.x(), position.y(), position.z(), radius, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
    }

    private static void badOmen(CrucibleBlockEntity c) {
        if (c.getLevel() == null) {
            return;
        }
        AABB aoe = new AABB(c.getBlockPos());
        aoe = aoe.inflate(5.0);
        if (!c.getLevel().isClientSide()) {
            List nearby_ents = c.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (e.isInvertedHealAndHarm()) continue;
                e.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 120000, 0, true, true));
                e.hurt(e.level().damageSources().magic(), 2.0f);
            }
            c.getLevel().playSound(null, c.getBlockPos(), SoundEvents.APPLY_EFFECT_BAD_OMEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void solidifyPortal(Level l, BlockPos p, Direction.Axis axis) {
        HyperPortalShape portal = new HyperPortalShape((LevelAccessor)l, p, axis);
        if (portal.isComplete()) {
            portal.createSolidPortalBlocks();
            if (!l.isClientSide) {
                FlagTrigger.triggerForNearbyPlayers((ServerLevel)l, (FlagTrigger)((Object)ReactiveCriterionTriggers.PORTAL_FREEZE.get()), p, 9);
            }
        }
    }

    private static void preventReactions(CrucibleBlockEntity crucible) {
        crucible.reactions_paused = true;
    }

    private static void expelReaction(CrucibleBlockEntity crucible, ItemEntity thread) {
        Level level;
        if (crucible.getLevel() == null) {
            return;
        }
        boolean is_reactive = false;
        for (ReactionStatusEntry entry : crucible.getReactionStatus()) {
            if (!entry.status().equals((Object)Reaction.Status.REACTING)) continue;
            is_reactive = true;
            break;
        }
        if (!is_reactive) {
            return;
        }
        ReactorEntity entity = new ReactorEntity(ReactiveEntityTypes.REACTOR.get(), crucible.getLevel());
        entity.setPos(crucible.getPos().add(0.0, 1.0, 0.0));
        entity.setPowers(crucible.getPowerMap());
        entity.setLifespan(600);
        crucible.expendPower();
        crucible.getLevel().setBlock(crucible.getBlockPos(), (BlockState)crucible.getBlockState().setValue((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
        crucible.getLevel().addFreshEntity((Entity)entity);
        crucible.getLevel().playSound(null, crucible.getBlockPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
        crucible.getLevel().playSound((Entity)null, crucible.getBlockPos(), SoundEvents.BLAZE_SHOOT, SoundSource.BLOCKS, 1.0f, 0.7f);
        thread.getItem().shrink(1);
        if (thread.getItem().getCount() == 0) {
            thread.kill();
        }
        if ((level = crucible.getLevel()) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            FlagTrigger.triggerForNearbyPlayers(slevel, (FlagTrigger)((Object)ReactiveCriterionTriggers.GOLD_THREAD_REACTION.get()), crucible.getBlockPos(), 9);
        }
    }

    private static void saltMaterialCraft(CrucibleBlockEntity crucible, ItemEntity salt_item_entity) {
        if (crucible.getLevel() == null) {
            return;
        }
        if (crucible.getTotalPowerLevel() < 800 && crucible.getPowerLevel((Power)Powers.ACID_POWER.get()) <= 10) {
            return;
        }
        ItemStack material_stack = ((MaterialItem)((Object)ReactiveItems.MATERIAL.get())).getDefaultInstance();
        ResourceLocation material_id = MaterialMan.createOrFetchByFormula(crucible.getLevel(), new Formula(crucible.getPowerMap(), (Holder<Item>)salt_item_entity.getItem().getItemHolder()));
        material_stack.set((DataComponentType)ReactiveComponentTypes.MATERIAL_ID.get(), (Object)material_id);
        int max_amount_used = 1;
        int yield_multiplier = 1;
        YieldEntry yield_entry = (YieldEntry)salt_item_entity.getItem().getItemHolder().getData(ReactiveDataMaps.MATERIAL_SALT_YIELDS);
        if (yield_entry != null) {
            max_amount_used = yield_entry.max_input_items();
            yield_multiplier = yield_entry.yield_per_input();
        }
        int amount_used = Math.min(salt_item_entity.getItem().getCount(), max_amount_used);
        material_stack.setCount(amount_used * yield_multiplier);
        salt_item_entity.getItem().shrink(amount_used);
        if (salt_item_entity.getItem().getCount() <= 0) {
            salt_item_entity.kill();
        }
        Vec3 in_crucible = crucible.getBlockPos().getCenter();
        ItemEntity drop = new ItemEntity(crucible.getLevel(), in_crucible.x, in_crucible.y, in_crucible.z, material_stack);
        crucible.getLevel().addFreshEntity((Entity)drop);
        crucible.expendPower();
        crucible.setDirty();
    }
}

