/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class WindBombReaction
extends FreeEffectReaction {
    public WindBombReaction(String alias) {
        super(alias, ReactionEffects::flowTooStrong, (Power)Powers.FLOW_POWER.get());
        this.setReagentCost((Power)Powers.FLOW_POWER.get(), 1);
    }

    @Override
    public Reaction.Status conditionsMet(Reactor crucible) {
        Reaction.Status status = super.conditionsMet(crucible);
        if (status != Reaction.Status.REACTING) {
            return status;
        }
        if (this.checkBreezeRods(crucible)) {
            return Reaction.Status.REACTING;
        }
        return Reaction.Status.INHIBITED;
    }

    @Override
    public boolean isPerfect(Reactor crucible) {
        return super.isPerfect(crucible);
    }

    public boolean checkBreezeRods(Reactor crucible) {
        Level level = crucible.getLevel();
        if (level == null) {
            return true;
        }
        BlockPos crucible_pos = crucible.getBlockPos();
        Random wsv = WorldSpecificValue.getSource("breeze_rod_placements");
        BlockPos rod_1_pos = crucible_pos.offset(3, 1, 1);
        if (!level.getBlockState(rod_1_pos).is((Block)ReactiveBlocks.BREEZE_ROD.get())) {
            ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.SMALL_GUST, rod_1_pos, 0.5, 0.1, 5);
            return true;
        }
        Level level2 = crucible.getLevel();
        if (level2 instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level2;
            FlagTrigger.triggerForNearbyPlayers(slevel, (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_FAILED_FLOW_CONTAINMENT.value()), crucible_pos, 10);
        }
        BlockPos rod_2_pos = rod_1_pos.offset(wsv.nextInt(-3, 4), 0, wsv.nextInt(-3, 4));
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.SMALL_GUST, Vec3.atCenterOf((Vec3i)rod_1_pos).add(0.0, 0.5, 0.0), Vec3.atCenterOf((Vec3i)rod_2_pos).add(0.0, -0.5, 0.0), 5, 0.0);
        if (!level.getBlockState(rod_2_pos).is((Block)ReactiveBlocks.BREEZE_ROD.get())) {
            ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.SMALL_GUST, rod_2_pos, 0.5, 0.1, 5);
            return true;
        }
        BlockPos rod_3_pos = rod_2_pos.offset(wsv.nextInt(-3, 4), 0, wsv.nextInt(-3, 4));
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.SMALL_GUST, Vec3.atCenterOf((Vec3i)rod_2_pos).add(0.0, 0.5, 0.0), Vec3.atCenterOf((Vec3i)rod_3_pos).add(0.0, -0.5, 0.0), 5, 0.0);
        if (!level.getBlockState(rod_3_pos).is((Block)ReactiveBlocks.BREEZE_ROD.get())) {
            ParticleScribe.drawParticleSphere(level, (ParticleOptions)ParticleTypes.SMALL_GUST, rod_3_pos, 0.5, 0.1, 5);
            return true;
        }
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.SMALL_GUST, Vec3.atCenterOf((Vec3i)rod_3_pos).add(0.0, 0.5, 0.0), Vec3.atCenterOf((Vec3i)rod_1_pos).add(0.0, -0.5, 0.0), 5, 0.0);
        Level level3 = crucible.getLevel();
        if (level3 instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level3;
            FlagTrigger.triggerForNearbyPlayers(slevel, (FlagTrigger)((Object)ReactiveCriterionTriggers.SEE_FLOW_CONTAINMENT.value()), crucible_pos, 10);
        }
        return false;
    }
}

