/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.AnnihilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AstralReaction;
import dev.hyperlynx.reactive.alchemy.rxn.AstralSynthesisReaction;
import dev.hyperlynx.reactive.alchemy.rxn.BasePowerSynthesisReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CatalystEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import dev.hyperlynx.reactive.alchemy.rxn.DecomposeReaction;
import dev.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.OmenConversionReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.alchemy.rxn.SynthesisReaction;
import dev.hyperlynx.reactive.alchemy.rxn.WindBombReaction;
import dev.hyperlynx.reactive.datagen.ReactionAdvancementGenerator;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

public class ReactionMan {
    static boolean initialized = false;
    static boolean initializer_lock = false;
    private static final ReactionMap REACTIONS = new ReactionMap();
    public static ArrayList<Power> BASE_POWER_LIST = new ArrayList();

    public ReactionMan() {
        ReactionAdvancementGenerator.add("curse_assimilation");
        ReactionAdvancementGenerator.add("vital_kill");
        ReactionAdvancementGenerator.add("vital_eat");
        ReactionAdvancementGenerator.add("verdant_consume");
        ReactionAdvancementGenerator.add("vital_consume");
        ReactionAdvancementGenerator.add("verdant_growth");
        ReactionAdvancementGenerator.add("vital_growth");
        ReactionAdvancementGenerator.add("discharge_annihilation");
        ReactionAdvancementGenerator.add("smoke_annihilation");
        ReactionAdvancementGenerator.add("salt_annihilation");
        ReactionAdvancementGenerator.add("x_synthesis");
        ReactionAdvancementGenerator.add("y_synthesis");
        ReactionAdvancementGenerator.add("z_synthesis");
        ReactionAdvancementGenerator.add("growth");
        ReactionAdvancementGenerator.add("flames");
        ReactionAdvancementGenerator.add("levitation");
        ReactionAdvancementGenerator.add("sunlight");
        ReactionAdvancementGenerator.add("immobilize");
        ReactionAdvancementGenerator.add("soul_to_warp");
        ReactionAdvancementGenerator.add("warp_to_soul");
        ReactionAdvancementGenerator.add("compound_degradation");
        ReactionAdvancementGenerator.add("explosion_effect");
        ReactionAdvancementGenerator.add("formation_effect");
        ReactionAdvancementGenerator.add("block_fall_effect");
        ReactionAdvancementGenerator.add("slowfall_effect");
        ReactionAdvancementGenerator.add("astral_synthesis");
        ReactionAdvancementGenerator.add("astral");
        ReactionAdvancementGenerator.add("astral_curse_annihilation");
        ReactionAdvancementGenerator.add("size_grow_effect");
        ReactionAdvancementGenerator.add("size_shrink_effect");
        ReactionAdvancementGenerator.add("size_revert_effect");
        ReactionAdvancementGenerator.add("size_revert_effect_2");
        ReactionAdvancementGenerator.add("ominous_transformation");
        ReactionAdvancementGenerator.add("omen_settling");
        ReactionAdvancementGenerator.add("wind_bomb");
        ReactionAdvancementGenerator.add("lightning");
        ReactionAdvancementGenerator.add("chomp");
        ReactionAdvancementGenerator.add("cryo");
        ReactionAdvancementGenerator.add("nodule");
    }

    public List<Reaction> getReactions(Level level) {
        if (!initialized) {
            this.constructReactions(level);
        }
        return REACTIONS.values().stream().toList();
    }

    public List<String> getReactionAliases(Level level) {
        if (!initialized) {
            this.constructReactions(level);
        }
        return REACTIONS.keySet().stream().toList();
    }

    public Reaction get(Level level, String alias) {
        if (!initialized) {
            this.constructReactions(level);
        }
        return (Reaction)REACTIONS.get(alias);
    }

    private void constructReactions(Level level) {
        if (level.isClientSide()) {
            ReactiveMod.LOGGER.error("Client tried to construct reactions, ignoring...");
            return;
        }
        if (initializer_lock) {
            return;
        }
        ReactiveMod.LOGGER.info("Constructing reactions");
        initializer_lock = true;
        BASE_POWER_LIST.add((Power)Powers.BLAZE_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.WARP_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.SOUL_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.LIGHT_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.MIND_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.VITAL_POWER.get());
        BASE_POWER_LIST = WorldSpecificValue.shuffle("power_list_order", BASE_POWER_LIST);
        REACTIONS.add(new CurseAssimilationReaction("curse_assimilation"));
        REACTIONS.add(new AssimilationReaction("vital_kill", (Power)Powers.ACID_POWER.get(), (Power)Powers.VITAL_POWER.get()));
        REACTIONS.add(new AssimilationReaction("vital_eat", (Power)Powers.VITAL_POWER.get(), (Power)Powers.BODY_POWER.get()));
        int vvr = WorldSpecificValues.VERDANT_VITAL_RELATIONSHIP.get();
        switch (vvr) {
            case 2: {
                REACTIONS.add(new AssimilationReaction("verdant_consume", (Power)Powers.VERDANT_POWER.get(), (Power)Powers.VITAL_POWER.get()));
                break;
            }
            case 3: {
                REACTIONS.add(new AssimilationReaction("vital_consume", (Power)Powers.VITAL_POWER.get(), (Power)Powers.VERDANT_POWER.get()));
                break;
            }
            case 4: {
                REACTIONS.add(new SynthesisReaction("verdant_growth", (Power)Powers.VERDANT_POWER.get(), new Power[]{(Power)Powers.VITAL_POWER.get(), (Power)Powers.BODY_POWER.get()}));
                break;
            }
            case 5: {
                REACTIONS.add(new SynthesisReaction("vital_growth", (Power)Powers.VITAL_POWER.get(), new Power[]{(Power)Powers.VERDANT_POWER.get(), (Power)Powers.LIGHT_POWER.get()}));
            }
        }
        REACTIONS.add(new AnnihilationReaction("discharge_annihilation", BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(3), ReactionEffects::discharge).setStimulus(Reaction.Stimulus.NO_IRON_SYMBOL));
        REACTIONS.add(new AnnihilationReaction("smoke_annihilation", BASE_POWER_LIST.get(1), BASE_POWER_LIST.get(4), ReactionEffects::smoke).setStimulus(Reaction.Stimulus.NO_IRON_SYMBOL));
        REACTIONS.add(new AnnihilationReaction("salt_annihilation", BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(5), ReactionEffects::salt).setStimulus(Reaction.Stimulus.NO_IRON_SYMBOL));
        REACTIONS.add(new BasePowerSynthesisReaction("x_synthesis", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new BasePowerSynthesisReaction("y_synthesis", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new BasePowerSynthesisReaction("z_synthesis", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new EffectReaction("growth", ReactionEffects::growth, (Power)Powers.VERDANT_POWER.get(), (Power)Powers.MIND_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new FreeEffectReaction("flames", ReactionEffects::flamethrower, (Power)Powers.BLAZE_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new EffectReaction("levitation", ReactionEffects::levitation, (Power)Powers.LIGHT_POWER.get()).setCost(2).setStimulus(Reaction.Stimulus.END_CRYSTAL));
        REACTIONS.add(new EffectReaction("sunlight", ReactionEffects::sunlight, (Power)Powers.LIGHT_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new EffectReaction("immobilize", ReactionEffects::immobilize, (Power)Powers.WARP_POWER.get(), (Power)Powers.VERDANT_POWER.get()).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
        switch (WorldSpecificValues.CONDUIT_POWER.get()) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("soul_to_warp", (Power)Powers.SOUL_POWER.get(), new Power[]{(Power)Powers.WARP_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("warp_to_soul", (Power)Powers.WARP_POWER.get(), new Power[]{(Power)Powers.SOUL_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
            }
        }
        int order = WorldSpecificValues.EFFECT_ORDER.get();
        switch (order) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.Z_POWER.get(), (Item)ReactiveItems.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.X_POWER.get(), (Item)ReactiveItems.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
                break;
            }
            case 3: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL).markAlwaysPerfect());
                REACTIONS.add(new CatalystEffectReaction("slowfall_effect", ReactionEffects::slowfall, (Power)Powers.Y_POWER.get(), (Item)ReactiveItems.PHANTOM_RESIDUE.get()).markAlwaysPerfect());
            }
        }
        REACTIONS.add(new AstralSynthesisReaction("astral_synthesis", (Power)Powers.ASTRAL_POWER.get(), new Power[]{(Power)Powers.X_POWER.get(), (Power)Powers.Y_POWER.get(), (Power)Powers.Z_POWER.get()}).markAlwaysPerfect());
        REACTIONS.add(new AstralReaction("astral"));
        REACTIONS.add(new AnnihilationReaction("astral_curse_annihilation", (Power)Powers.ASTRAL_POWER.get(), (Power)Powers.CURSE_POWER.get(), ReactionEffects::creation).setCost(2));
        Reaction size_shrink_effect = new FreeEffectReaction("size_shrink_effect", ReactionEffects::shrink, (Power)Powers.MIND_POWER.get(), (Power)Powers.BODY_POWER.get(), (Power)Powers.ACID_POWER.get()).setStimulus(Reaction.Stimulus.NO_ELECTRIC);
        Reaction size_grow_effect = new FreeEffectReaction("size_grow_effect", ReactionEffects::grow, (Power)Powers.MIND_POWER.get(), (Power)Powers.BODY_POWER.get(), (Power)Powers.VERDANT_POWER.get()).setStimulus(Reaction.Stimulus.NO_ELECTRIC);
        Reaction size_revert_effect = new FreeEffectReaction("size_revert_effect", ReactionEffects::revert_from_small, (Power)Powers.MIND_POWER.get(), (Power)Powers.BODY_POWER.get(), (Power)Powers.ACID_POWER.get()).setStimulus(Reaction.Stimulus.ELECTRIC);
        size_revert_effect.cloneReagentsOf(size_shrink_effect);
        Reaction size_revert_effect_2 = new FreeEffectReaction("size_revert_effect_2", ReactionEffects::revert_from_large, (Power)Powers.MIND_POWER.get(), (Power)Powers.BODY_POWER.get(), (Power)Powers.VERDANT_POWER.get()).setStimulus(Reaction.Stimulus.ELECTRIC);
        size_revert_effect_2.cloneReagentsOf(size_grow_effect);
        REACTIONS.addAll(size_shrink_effect, size_grow_effect, size_revert_effect, size_revert_effect_2);
        REACTIONS.add(new OmenConversionReaction("ominous_transformation"));
        REACTIONS.add(new FreeEffectReaction("omen_settling", ReactionEffects::omenSettling, (Power)Powers.OMEN_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new CatalystEffectReaction("chomp", ReactionEffects::chomp, (Power)Powers.OMEN_POWER.get(), Items.IRON_INGOT));
        REACTIONS.add(new WindBombReaction("wind_bomb"));
        REACTIONS.add(new EffectReaction("lightning", ReactionEffects::lightning, (Power)Powers.FLOW_POWER.get(), (Power)Powers.LIGHT_POWER.get()).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new EffectReaction("cryo", ReactionEffects::cryo, (Power)Powers.ACID_POWER.get(), (Power)Powers.BLAZE_POWER.get()));
        REACTIONS.add(new EffectReaction("nodule", ReactionEffects::noduleGrowth, (Power)Powers.Z_POWER.get(), (Power)Powers.WARP_POWER.get()).setCost(4));
        NeoForge.EVENT_BUS.post((Event)new ReactionConstructEvent(level));
        initialized = true;
        initializer_lock = false;
    }

    public static void addReactions(Reaction ... additions) {
        REACTIONS.addAll(additions);
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.reset();
    }

    public void reset() {
        if (initialized) {
            ReactiveMod.LOGGER.info("Resetting ReactionMan");
            initialized = false;
            REACTIONS.clear();
            BASE_POWER_LIST.clear();
            NeoForge.EVENT_BUS.post((Event)new ReactionResetEvent());
        }
    }

    protected static class ReactionMap
    extends HashMap<String, Reaction> {
        protected ReactionMap() {
        }

        public void add(Reaction reaction) {
            String alias = reaction.alias;
            if (((List)ConfigMan.SERVER.disabledReactions.get()).contains(alias)) {
                return;
            }
            super.put(reaction.alias, reaction);
        }

        public void addAll(Reaction ... reactions) {
            for (Reaction reaction : reactions) {
                this.add(reaction);
            }
        }
    }

    public static class ReactionConstructEvent
    extends Event {
        public final Level level;

        public ReactionConstructEvent(Level level) {
            this.level = level;
        }
    }

    public static class ReactionResetEvent
    extends Event {
    }
}

