/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.advancements.FlagTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.ActiveGoldFoamBlock;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.NoduleBlock;
import dev.hyperlynx.reactive.blocks.SaltFilledCrucibleBlock;
import dev.hyperlynx.reactive.blocks.ShulkerCrucibleBlock;
import dev.hyperlynx.reactive.blocks.UnformedMatterBlock;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.entites.ReactorEntity;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.SecretScaleItem;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import dev.hyperlynx.reactive.registration.ReactiveItems;
import dev.hyperlynx.reactive.registration.ReactiveMobEffects;
import dev.hyperlynx.reactive.registration.ReactiveParticles;
import dev.hyperlynx.reactive.registration.ReactiveSoundEvents;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ReactionEffects {
    public static void explosion(Reactor reactor) {
        BlockPos pos = reactor.getBlockPos();
        ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.SMOKE, pos, reactor.getAreaMemory().fetch(reactor.getLevel(), (Block)ReactiveBlocks.GOLD_SYMBOL.get()), 20, 7, 0.8f);
        if (reactor.getAreaMemory().exists(reactor.getLevel(), (Block)ReactiveBlocks.IRON_SYMBOL.get())) {
            ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.SMOKE, reactor.getAreaMemory().fetch(reactor.getLevel(), (Block)ReactiveBlocks.GOLD_SYMBOL.get()), reactor.getAreaMemory().fetch(reactor.getLevel(), (Block)ReactiveBlocks.IRON_SYMBOL.get()), 20, 7, 0.8f);
        } else {
            reactor.expendPower();
            if (reactor instanceof CrucibleBlockEntity) {
                CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
                SpecialCaseMan.checkEmptySpecialCases(crucible);
                reactor.getLevel().setBlock(pos, (BlockState)reactor.getLevel().getBlockState(pos).setValue((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
            }
            reactor.getLevel().explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
            if (reactor.getAreaMemory().exists(reactor.getLevel(), (Block)ReactiveBlocks.GOLD_SYMBOL.get())) {
                reactor.getLevel().removeBlock(reactor.getAreaMemory().fetch(reactor.getLevel(), (Block)ReactiveBlocks.GOLD_SYMBOL.get()), true);
            }
        }
    }

    public static void foaming(Reactor reactor) {
        BlockPos symbol_position = reactor.getAreaMemory().fetch(reactor.getLevel(), (Block)ReactiveBlocks.GOLD_SYMBOL.get());
        if (symbol_position == null) {
            return;
        }
        reactor.getLevel().setBlock(symbol_position, ((ActiveGoldFoamBlock)((Object)ReactiveBlocks.ACTIVE_GOLD_FOAM.get())).defaultBlockState(), 2);
        ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.EFFECT, (float)reactor.getBlockPos().getX() + 0.5f, (float)reactor.getBlockPos().getY() + 0.5625f, (float)reactor.getBlockPos().getZ() + 0.5f, (double)symbol_position.getX() + 0.5, (double)symbol_position.getY() + 0.5, (double)symbol_position.getZ() + 0.5, 12, 7, 0.4);
    }

    public static void smoke(Reactor reactor) {
        if ((double)reactor.getLevel().random.nextFloat() < 0.4) {
            AABB aoe = new AABB(reactor.getBlockPos());
            aoe = aoe.inflate(3.0);
            List nearby_ents = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (!CrystalIronItem.effectNotBlocked(e, 1)) continue;
                e.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1));
                e.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, 1));
                e.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
            }
        }
    }

    public static void salt(Reactor reactor) {
        if (reactor.getTotalPowerLevel() < WorldSpecificValue.get("salt_overflow_threshold", 1000, 1300)) {
            ItemEntity salt_drop = new ItemEntity(reactor.getLevel(), (double)reactor.getBlockPos().getX() + 0.5, (double)reactor.getBlockPos().getY() + 0.5, (double)reactor.getBlockPos().getZ() + 0.6, ((Item)ReactiveItems.SALT.get()).getDefaultInstance());
            reactor.getLevel().addFreshEntity((Entity)salt_drop);
        } else {
            if (reactor instanceof CrucibleBlockEntity) {
                CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
                CrucibleBlockEntity.empty(reactor.getLevel(), reactor.getBlockPos(), reactor.getBlockState(), crucible);
                if (reactor.getBlockState().getBlock() instanceof ShulkerCrucibleBlock) {
                    ItemEntity shell_drop = new ItemEntity(reactor.getLevel(), (double)reactor.getBlockPos().getX() + 0.5, (double)reactor.getBlockPos().getY() + 0.5, (double)reactor.getBlockPos().getZ() + 0.6, Items.SHULKER_SHELL.getDefaultInstance());
                    reactor.getLevel().addFreshEntity((Entity)shell_drop);
                }
                reactor.getLevel().setBlock(reactor.getBlockPos(), ((SaltFilledCrucibleBlock)((Object)ReactiveBlocks.SALTY_CRUCIBLE.get())).defaultBlockState(), 2);
            } else if (reactor instanceof ReactorEntity) {
                ReactorEntity entity = (ReactorEntity)reactor;
                entity.getLevel().setBlock(entity.getBlockPos(), ((Block)ReactiveBlocks.SALT_BLOCK.get()).defaultBlockState(), 2);
                entity.kill();
            }
            reactor.getLevel().playSound(null, reactor.getBlockPos(), SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void discharge(Reactor reactor) {
        Level level = reactor.getLevel();
        reactor.addElectricCharge(5);
        if (reactor.getElectricCharge() > 21) {
            BlockPos potential_rod = reactor.getAreaMemory().fetch(level, Blocks.LIGHTNING_ROD);
            if (potential_rod != null) {
                if (!reactor.getLevel().isClientSide) {
                    ((LightningRodBlock)Blocks.LIGHTNING_ROD).onLightningStrike(reactor.getLevel().getBlockState(potential_rod), level, potential_rod);
                    ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, reactor.getPos().x, reactor.getPos().y, reactor.getPos().z, (double)potential_rod.getX() + 0.5, (double)potential_rod.getY() + 0.5, (double)potential_rod.getZ() + 0.5, 8, 10, 0.6);
                    reactor.getLevel().playSound(null, potential_rod, (SoundEvent)ReactiveSoundEvents.ZAP.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else {
                AABB aoe = new AABB(reactor.getBlockPos());
                aoe = aoe.inflate((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
                List nearby_ents = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
                LivingEntity victim = null;
                for (LivingEntity e : nearby_ents) {
                    if (victim != null && !(e.distanceToSqr(Vec3.atCenterOf((Vec3i)reactor.getBlockPos())) < victim.distanceToSqr(Vec3.atCenterOf((Vec3i)reactor.getBlockPos()))) || !BeamHelper.hasLineOfSight(level, Vec3.atCenterOf((Vec3i)reactor.getBlockPos()), e.getEyePosition(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, reactor.getBlockState().getBlock())) continue;
                    victim = e;
                }
                if (victim == null) {
                    return;
                }
                if (!level.isClientSide) {
                    if (CrystalIronItem.effectNotBlocked(victim, 2)) {
                        victim.hurt(reactor.getLevel().damageSources().magic(), 5.0f);
                    }
                    ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, reactor.getPos().x, reactor.getPos().y, reactor.getPos().z, victim.getX(), (double)(victim.getEyeHeight() / 2.0f) + victim.getY(), victim.getZ(), 8, 10, 0.3);
                    reactor.getLevel().playSound(null, victim.getX(), victim.getY(), victim.getZ(), (SoundEvent)ReactiveSoundEvents.ZAP.get(), SoundSource.BLOCKS, 0.5f, 0.98f + reactor.getLevel().random.nextFloat() * 0.05f);
                }
            }
            reactor.setElectricCharge(0);
        }
        reactor.setDirty();
    }

    public static void levitation(Reactor reactor) {
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(12.0);
        List nearby_ents = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.BE_LEVITATED.get())).trigger(player);
                }
            }
            ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.END_ROD, reactor.getPos().x, reactor.getPos().y, reactor.getPos().z, victim.getX(), victim.getEyeY() - 0.2, victim.getZ(), 8, 7, 0.74);
            float pitch = 0.8f + reactor.getLevel().random.nextFloat() * 0.1f;
            reactor.getLevel().playSound(null, victim.getX(), victim.getY(), victim.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 0.3f, pitch);
            reactor.getLevel().playSound(null, victim.getX(), victim.getY(), victim.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 0.3f, pitch / 2.0f);
        }
    }

    public static void slowfall(Reactor reactor) {
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(12.0);
        List nearby_ents = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.BE_SLOWFALLED.get())).trigger(player);
                }
            }
            ParticleScribe.drawExactParticleRing(reactor.getLevel(), (ParticleOptions)ParticleTypes.END_ROD, reactor.getPos(), 0.6, 1);
            reactor.getLevel().playSound(null, victim.getX(), victim.getY(), victim.getZ(), SoundEvents.CONDUIT_AMBIENT_SHORT, SoundSource.BLOCKS, 0.1f, 1.2f);
        }
        if (reactor.getLinkedCrystal() != null && reactor.getPowerLevel((Power)Powers.LIGHT_POWER.get()) > WorldSpecificValue.get("levitationcost", 10, 30)) {
            ReactionEffects.craftSecretScale(reactor);
        }
    }

    private static void craftSecretScale(Reactor reactor) {
        for (Entity entity : CrucibleBlock.getEntitesInside(reactor.getBlockPos(), reactor.getLevel())) {
            ItemEntity item_entity;
            if (!(entity instanceof ItemEntity) || !(item_entity = (ItemEntity)entity).getItem().is((Item)ReactiveItems.PHANTOM_RESIDUE.get())) continue;
            ParticleScribe.drawParticleZigZag(reactor.getLevel(), (ParticleOptions)ParticleTypes.END_ROD, reactor.getBlockPos().getX(), reactor.getBlockPos().getY(), reactor.getBlockPos().getZ(), entity.getX(), entity.getY(), entity.getZ(), 25, 10, 0.9);
            reactor.getLevel().playSound(null, reactor.getBlockPos(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 0.8f, 0.8f);
            int count = item_entity.getItem().getCount();
            item_entity.kill();
            ItemStack drop_stack = ((SecretScaleItem)((Object)ReactiveItems.SECRET_SCALE.get())).getDefaultInstance();
            drop_stack.setCount(count);
            ItemEntity secret_scale = new ItemEntity(reactor.getLevel(), (double)reactor.getBlockPos().getX() + 0.5, (double)reactor.getBlockPos().getY() + 0.6, (double)reactor.getBlockPos().getZ() + 0.5, drop_stack);
            secret_scale.setPickUpDelay(20);
            reactor.getLevel().addFreshEntity((Entity)secret_scale);
            reactor.getLevel().setBlock(reactor.getBlockPos(), (BlockState)reactor.getBlockState().setValue((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public static void growth(Reactor reactor) {
        Random random = new Random();
        BlockPos target = reactor.getBlockPos().offset(random.nextInt(-32, 32), random.nextInt(-1, 0), random.nextInt(-32, 32));
        if (Objects.requireNonNull(reactor.getLevel()).getBlockState(target).getBlock() instanceof BonemealableBlock) {
            ((BonemealableBlock)reactor.getLevel().getBlockState(target).getBlock()).performBonemeal((ServerLevel)reactor.getLevel(), reactor.getLevel().random, target, reactor.getLevel().getBlockState(target));
        }
    }

    public static void flamethrower(Reactor reactor) {
        if (reactor.getLevel() == null) {
            return;
        }
        AABB blast_zone = new AABB(reactor.getBlockPos());
        blast_zone = blast_zone.inflate(2.0, 5.0, 2.0);
        List nearby_ents = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, blast_zone);
        for (LivingEntity e : nearby_ents) {
            if (!BeamHelper.hasLineOfSight(reactor.getLevel(), reactor.getBlockPos().getCenter(), e.getEyePosition(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, reactor.getBlockState().getBlock())) continue;
            e.setRemainingFireTicks(140);
        }
    }

    public static void sunlight(Reactor reactor) {
        int range = 12;
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate((double)range);
        List nearby_monsters = reactor.getLevel().getEntitiesOfClass(Monster.class, aoe);
        for (Monster m : nearby_monsters) {
            if (!m.isInvertedHealAndHarm() || !(m.getPosition(0.0f).distanceTo(reactor.getBlockPos().getCenter()) < (double)range)) continue;
            m.hurt(reactor.getLevel().damageSources().inFire(), 3.0f);
            m.setRemainingFireTicks(100);
        }
        ParticleScribe.drawExactParticleRing(reactor.getLevel(), (ParticleOptions)ParticleTypes.END_ROD, reactor.getPos().add(0.0, 0.1, 0.0), 12.0, 20);
    }

    public static void blockfall(Reactor reactor) {
        Level level = reactor.getLevel();
        RandomSource random = level.random;
        BlockPos symbol_pos = reactor.getAreaMemory().fetch(level, (Block)ReactiveBlocks.GOLD_SYMBOL.get());
        if (symbol_pos == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            BlockState target_state;
            BlockPos target = symbol_pos.offset(random.nextInt(-4, 4), random.nextInt(0, 4), random.nextInt(-4, 4));
            if (target == reactor.getBlockPos() || target == symbol_pos || (target_state = level.getBlockState(target)).isAir() || !BlockMoveChecker.canMakeBlockFall(reactor.getLevel(), target, target_state)) continue;
            FallingBlockEntity.fall((Level)level, (BlockPos)target, (BlockState)target_state);
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ParticleTypes.END_ROD, reactor.getBlockPos(), target, 8, 32, 0.7f);
            ItemEntity drop = new ItemEntity(level, (double)reactor.getBlockPos().getX() + 0.5, (double)reactor.getBlockPos().getY() + 0.6, (double)reactor.getBlockPos().getZ() + 0.5, ((Item)ReactiveItems.MOTION_SALT.get()).getDefaultInstance());
            level.addFreshEntity((Entity)drop);
        }
    }

    public static void immobilize(Reactor reactor) {
        Level level = reactor.getLevel();
        if (level == null) {
            return;
        }
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(2.0);
        List nearby = level.getEntitiesOfClass(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            MobEffectInstance stop;
            Player player;
            ParticleScribe.drawParticleReactionSurface(level, (ParticleOptions)ParticleTypes.REVERSE_PORTAL, reactor);
            if (!CrystalIronItem.effectNotBlocked(living, 1)) continue;
            if (living instanceof Player && (player = (Player)living).isShiftKeyDown()) {
                stop = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 50);
                player.addEffect(stop);
                continue;
            }
            stop = new MobEffectInstance(ReactiveMobEffects.IMMOBILE, 50, 0, true, false, true);
            living.addEffect(stop);
        }
    }

    public static void creation(Reactor reactor) {
        Level level = Objects.requireNonNull(reactor.getLevel());
        if ((double)level.random.nextFloat() < 0.35) {
            for (BlockPos creation_point : ReactionEffects.getCreationPoints(reactor.getBlockPos())) {
                if (!level.getBlockState(creation_point).isAir() || !level.isLoaded(creation_point)) continue;
                if ((double)level.random.nextFloat() < 0.34) {
                    level.setBlock(creation_point, ((Block)ReactiveBlocks.CREATION_SALT_BLOCK.get()).defaultBlockState(), 2);
                    level.updateNeighborsAt(creation_point, (Block)ReactiveBlocks.CREATION_SALT_BLOCK.get());
                } else {
                    level.setBlock(creation_point, ((UnformedMatterBlock)((Object)ReactiveBlocks.UNFORMED_MATTER.get())).defaultBlockState(), 2);
                    level.updateNeighborsAt(creation_point, (Block)ReactiveBlocks.UNFORMED_MATTER.get());
                }
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ReactiveParticles.STARDUST, reactor.getBlockPos(), creation_point, 10, 5, 0.5);
                break;
            }
        }
    }

    public static Set<BlockPos> getCreationPoints(BlockPos origin) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Random wsv_source = WorldSpecificValue.getSource("creation_points");
        while (points.size() < 3) {
            points.add(origin.offset(wsv_source.nextInt(0, 3) * 2 - 3, wsv_source.nextInt(0, 2) * 2 + 2, wsv_source.nextInt(0, 3) * 2 - 3));
        }
        return points;
    }

    public static void flowTooStrong(Reactor reactor) {
        int flow = reactor.getPowerLevel((Power)Powers.FLOW_POWER.get());
        reactor.expendPower((Power)Powers.FLOW_POWER.get(), flow);
        reactor.addPower((Power)Powers.LIGHT_POWER.get(), flow / 3);
        reactor.setElectricCharge(reactor.getElectricCharge() + 20);
        SpecialCaseMan.windBomb(reactor.getLevel(), Vec3.atCenterOf((Vec3i)reactor.getBlockPos()));
    }

    public static void omenSettling(Reactor reactor) {
        if (reactor.getLevel().random.nextFloat() < 0.1f) {
            reactor.addPower((Power)Powers.CURSE_POWER.get(), 1);
        }
        reactor.addPower((Power)Powers.SOUL_POWER.get(), 2);
    }

    public static void chomp(Reactor reactor) {
        Level level = reactor.getLevel();
        assert (level != null);
        for (Entity entity : CrucibleBlock.getEntitesInside(reactor.getBlockPos(), level)) {
            ItemEntity item;
            if (!(entity instanceof ItemEntity) || !(item = (ItemEntity)entity).getItem().is(Items.IRON_INGOT)) continue;
            item.kill();
        }
        Vec3 pos = Vec3.atCenterOf((Vec3i)reactor.getBlockPos());
        EvokerFangs fangs = new EvokerFangs(level, pos.x, pos.y + 0.48, pos.z, 0.0f, 10, null);
        reactor.getLevel().addFreshEntity((Entity)fangs);
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(4.0);
        List nearby = level.getEntitiesOfClass(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            EvokerFangs targeted_fangs = new EvokerFangs(level, living.position().x, living.position().y, living.position().z, 0.0f, 10, null);
            reactor.getLevel().addFreshEntity((Entity)targeted_fangs);
        }
    }

    public static void shrink(Reactor reactor) {
        ReactionEffects.resizeNearby(reactor, (Double)ConfigMan.SERVER.shrinkSmallSize.get(), (Double)ConfigMan.SERVER.shrinkSmallStep.get(), ResizeMode.REDUCE, (ParticleOptions)ReactiveParticles.ACID_BUBBLE);
    }

    public static void grow(Reactor reactor) {
        ReactionEffects.resizeNearby(reactor, (Double)ConfigMan.SERVER.growLargeSize.get(), (Double)ConfigMan.SERVER.growLargeStep.get(), ResizeMode.ENLARGE, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
    }

    public static void revert_from_large(Reactor reactor) {
        ReactionEffects.resizeNearby(reactor, 1.0, 0.6, ResizeMode.REDUCE, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK);
    }

    public static void revert_from_small(Reactor reactor) {
        ReactionEffects.resizeNearby(reactor, 1.0, 0.6, ResizeMode.ENLARGE, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK);
    }

    private static void resizeNearby(Reactor reactor, double new_scale, double new_step_height, ResizeMode mode, ParticleOptions particle) {
        if ((double)Objects.requireNonNull(reactor.getLevel()).random.nextFloat() < 0.4) {
            AABB aoe = new AABB(reactor.getBlockPos());
            aoe = aoe.inflate(3.0);
            List victims = reactor.getLevel().getEntitiesOfClass(LivingEntity.class, aoe);
            for (LivingEntity victim : victims) {
                if (!CrystalIronItem.effectNotBlocked(victim, 2)) continue;
                double current_scale = victim.getAttributeValue(Attributes.SCALE);
                if (!(mode == ResizeMode.ENLARGE && current_scale < new_scale) && (mode != ResizeMode.REDUCE || !(current_scale > new_scale))) continue;
                Objects.requireNonNull(victim.getAttribute(Attributes.SCALE)).setBaseValue(new_scale);
                Objects.requireNonNull(victim.getAttribute(Attributes.STEP_HEIGHT)).setBaseValue(new_step_height);
                ParticleScribe.drawParticleZigZag(reactor.getLevel(), particle, reactor.getPos().x, reactor.getPos().y, reactor.getPos().z, victim.getEyePosition().x, victim.getEyePosition().y, victim.getEyePosition().z, 20, 5, 0.9);
                reactor.getLevel().playSound(null, reactor.getBlockPos(), (SoundEvent)ReactiveSoundEvents.ZAP.get(), SoundSource.BLOCKS);
                reactor.getLevel().playSound(null, reactor.getBlockPos(), SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 0.5f, 1.3f + reactor.getLevel().random.nextFloat() * 0.2f);
                victim.hurt(reactor.getLevel().damageSources().magic(), 1.0f);
                if (!(victim instanceof ServerPlayer)) continue;
                ServerPlayer splayer = (ServerPlayer)victim;
                if (new_scale == 1.0) {
                    ((FlagTrigger)((Object)ReactiveCriterionTriggers.SIZE_REVERTED.get())).trigger(splayer);
                    continue;
                }
                ((FlagTrigger)((Object)ReactiveCriterionTriggers.SIZE_CHANGED.get())).trigger(splayer);
            }
        }
    }

    public static void lightning(Reactor reactor) {
        Level level = reactor.getLevel();
        assert (level != null);
        LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
        if (reactor.getAreaMemory().exists(level, Blocks.LIGHTNING_ROD)) {
            bolt.setPos(Vec3.atCenterOf((Vec3i)reactor.getAreaMemory().fetch(level, Blocks.LIGHTNING_ROD)));
        } else {
            bolt.setPos(Vec3.atCenterOf((Vec3i)reactor.getBlockPos()));
        }
        level.addFreshEntity((Entity)bolt);
        reactor.expendPower((Power)Powers.LIGHT_POWER.get(), reactor.maxPower());
        reactor.setDirty();
    }

    public static void cryo(Reactor reactor) {
        Level level = reactor.getLevel();
        if (level == null) {
            return;
        }
        AABB aoe = new AABB(reactor.getBlockPos());
        aoe = aoe.inflate(5.0);
        List nearby = level.getEntitiesOfClass(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            if (!CrystalIronItem.effectNotBlocked(living, 1)) continue;
            living.setTicksFrozen(200);
        }
        BlockPos.betweenClosedStream((AABB)aoe).forEach(pos -> {
            if (level.getBlockState(pos).is(Blocks.FROSTED_ICE)) {
                level.setBlock(pos, Blocks.FROSTED_ICE.defaultBlockState(), 2);
            }
            if (level.getBlockState(pos).is(Blocks.WATER) && level.getBlockState(pos.above()).isAir()) {
                level.setBlock(pos, Blocks.FROSTED_ICE.defaultBlockState(), 2);
                reactor.addPower((Power)Powers.BLAZE_POWER.get(), 3);
            }
        });
    }

    public static void noduleGrowth(Reactor reactor) {
        Level level = reactor.getLevel();
        if (level == null) {
            return;
        }
        int range = 4;
        BlockPos pos = reactor.getBlockPos().offset(level.random.nextInt(-range, range + 1), level.random.nextInt(-1, range), level.random.nextInt(-range, range + 1));
        if (!level.getBlockState(pos).isAir()) {
            if (level.getBlockState(pos).is((Block)ReactiveBlocks.UNGROWN_NODULE.get())) {
                BlockState old_state = level.getBlockState(pos);
                Direction direction = (Direction)old_state.getValue((Property)NoduleBlock.FACING);
                level.setBlock(pos, (BlockState)((NoduleBlock)((Object)ReactiveBlocks.NODULE.get())).defaultBlockState().setValue((Property)NoduleBlock.FACING, (Comparable)direction), 2);
                ReactionEffects.runNodulePlaceEffects(pos, direction, level, reactor);
                level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.2f, 0.7f + level.random.nextFloat() * 0.1f);
            }
            return;
        }
        for (Direction direction : Direction.allShuffled((RandomSource)level.random)) {
            BlockPos side_pos = pos.offset(new Vec3i(direction.getStepX(), direction.getStepY(), direction.getStepZ()));
            if (!level.getBlockState(side_pos).isCollisionShapeFullBlock((BlockGetter)level, side_pos)) continue;
            level.setBlock(pos, (BlockState)((NoduleBlock)((Object)ReactiveBlocks.UNGROWN_NODULE.get())).defaultBlockState().setValue((Property)NoduleBlock.FACING, (Comparable)direction), 2);
            ReactionEffects.runNodulePlaceEffects(pos, direction, level, reactor);
            return;
        }
    }

    private static void runNodulePlaceEffects(BlockPos pos, Direction direction, Level level, Reactor reactor) {
        reactor.expendPower((Power)Powers.WARP_POWER.get(), 4);
        level.playSound(null, pos, SoundEvents.TUFF_PLACE, SoundSource.BLOCKS, 1.0f, 1.2f);
        Vec3 beam_target = pos.getCenter().add(new Vec3(direction.step()).scale(0.3));
        ParticleScribe.drawParticleLine(level, (ParticleOptions)new EnergyParticle.Options(0.2f, ((Power)Powers.Z_POWER.get()).getColor(), beam_target, false), reactor.getBlockPos().getCenter(), beam_target, 50, (double)0.05f);
    }

    static enum ResizeMode {
        ENLARGE,
        REDUCE;

    }
}

