/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.advancements.ReactionTrigger;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.registration.ReactiveBlocks;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public abstract class Reaction {
    protected Map<Power, Integer> reagents = new HashMap<Power, Integer>();
    protected Stimulus stimulus = Stimulus.NONE;
    protected MutableComponent name = Component.literal((String)"Error!");
    public boolean always_perfect = false;
    final String alias;

    protected Reaction(String alias) {
        this.alias = alias;
    }

    public Reaction(String alias, int max_reagent_count) {
        this.alias = alias;
        this.name = Component.translatable((String)("reaction.reactive." + alias));
        int reagent_count = max_reagent_count < 3 ? max_reagent_count : WorldSpecificValue.get(alias + "reagent_count", 2, max_reagent_count);
        int i = 0;
        while (this.reagents.size() < reagent_count) {
            Power chosen_power = WorldSpecificValue.getFromCollection(alias + "r" + i, ReactionMan.BASE_POWER_LIST);
            int min = WorldSpecificValue.get(alias + "r" + i, 1, 400);
            this.reagents.put(chosen_power, min);
            ++i;
        }
    }

    public Reaction(String alias, Power ... powers) {
        this.alias = alias;
        this.name = Component.translatable((String)("reaction.reactive." + alias));
        for (Power p : powers) {
            this.reagents.put(p, WorldSpecificValue.get(alias + p.getId(), 1, 400));
        }
    }

    public MutableComponent getName() {
        return this.name.copy();
    }

    public Reaction setStimulus(Stimulus rxs) {
        this.stimulus = rxs;
        return this;
    }

    public Stimulus getStimulus() {
        return this.stimulus;
    }

    public Map<Power, Integer> getReagents() {
        return this.reagents;
    }

    public Reaction setReagentCost(Power reagent, int cost) {
        this.reagents.put(reagent, cost);
        return this;
    }

    public Reaction markAlwaysPerfect() {
        this.always_perfect = true;
        return this;
    }

    public void cloneReagentsOf(Reaction other) {
        this.reagents = other.reagents;
    }

    public String getAlias() {
        return this.alias;
    }

    public Status conditionsMet(Reactor reactor) {
        boolean missing_a_power = false;
        boolean too_little_power = false;
        for (Power p : this.reagents.keySet()) {
            if (p.checkReactivity(reactor.getPowerLevel(p), this.reagents.get(p))) continue;
            too_little_power = true;
            if (reactor.getPowerLevel(p) != 0) continue;
            missing_a_power = true;
            break;
        }
        if (too_little_power) {
            if (missing_a_power) {
                return Status.STABLE;
            }
            return Status.POWER_TOO_WEAK;
        }
        boolean met_conditions = this.checkStimulus(reactor);
        if (met_conditions) {
            if (reactor.areReactionsPaused()) {
                return Status.INHIBITED;
            }
            if (reactor.getPowerLevel((Power)Powers.BODY_POWER.get()) > WorldSpecificValue.get("body_inhibition_threshold", 20, 200) && !this.reagents.containsKey(Powers.BODY_POWER.get())) {
                return Status.INHIBITED;
            }
            return Status.REACTING;
        }
        if (this.stimulus == Stimulus.NO_ELECTRIC) {
            return Status.INHIBITED;
        }
        if (this.reagents.size() == 1) {
            return Status.VOLATILE;
        }
        return Status.MISSING_STIMULUS;
    }

    private boolean checkStimulus(Reactor reactor) {
        return switch (this.stimulus.ordinal()) {
            case 4 -> this.checkEndCrystal(reactor);
            case 1 -> reactor.checkGoldSymbol();
            case 2 -> {
                if (reactor.getElectricCharge() > 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (reactor.getElectricCharge() == 0) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (!reactor.getAreaMemory().exists(reactor.getLevel(), (Block)ReactiveBlocks.IRON_SYMBOL.get())) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean checkEndCrystal(Reactor reactor) {
        Level level = reactor.getLevel();
        if (reactor.getLinkedCrystal() != null && !reactor.getLinkedCrystal().isRemoved()) {
            reactor.setUsedCrystalThisCycle(true);
            return true;
        }
        if (level.isClientSide) {
            return false;
        }
        if (((ServerLevel)level).getDragonFight() != null) {
            return false;
        }
        int range = (Integer)ConfigMan.COMMON.crucibleRange.get();
        AABB aoe = new AABB(reactor.getBlockPos().offset(-range, -range, -range).getCenter(), reactor.getBlockPos().offset(range, range, range).getCenter());
        List end_crystals = level.getEntitiesOfClass(EndCrystal.class, aoe);
        if (end_crystals.isEmpty()) {
            return false;
        }
        ((EndCrystal)end_crystals.getFirst()).setBeamTarget(reactor.getBlockPos().below(2));
        reactor.setLinkedCrystal((EndCrystal)end_crystals.getFirst());
        reactor.setUsedCrystalThisCycle(true);
        return true;
    }

    public void run(Reactor reactor) {
        Level level = reactor.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        reactor.getLevel().gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, reactor.getBlockPos(), GameEvent.Context.of((BlockState)reactor.getBlockState()));
        ReactionTrigger.triggerForNearbyPlayers(server, this.alias, reactor.getBlockPos(), 6);
        if (this.always_perfect || this.isPerfect(reactor)) {
            ReactionTrigger.triggerPerfectForNearbyPlayers(server, this.alias, reactor.getBlockPos(), 6);
        }
    }

    public boolean isPerfect(Reactor reactor) {
        return reactor.getPowerCount() == this.reagents.size();
    }

    public String toString() {
        return this.alias;
    }

    public static enum Stimulus {
        NONE,
        GOLD_SYMBOL,
        ELECTRIC,
        NO_ELECTRIC,
        END_CRYSTAL,
        NO_END_CRYSTAL,
        NO_IRON_SYMBOL;

    }

    public static enum Status {
        STABLE,
        VOLATILE,
        MISSING_CATALYST,
        INHIBITED,
        POWER_TOO_WEAK,
        MISSING_STIMULUS,
        REACTING;

    }
}

