/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;

public class AstralReaction
extends Reaction {
    public AstralReaction(String alias) {
        super(alias, 0);
    }

    @Override
    public boolean isPerfect(Reactor crucible) {
        return true;
    }

    @Override
    public void run(Reactor reactor) {
        super.run(reactor);
        reactor.addPower((Power)Powers.ASTRAL_POWER.get(), reactor.maxPower());
        reactor.expendPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValues.CURSE_RATE.get() + 4);
    }

    @Override
    public Reaction.Status conditionsMet(Reactor reactor) {
        if (reactor.getPowerLevel((Power)Powers.ASTRAL_POWER.get()) > 0 && reactor.getTotalPowerLevel() > reactor.getPowerLevel((Power)Powers.ASTRAL_POWER.get())) {
            return Reaction.Status.REACTING;
        }
        return Reaction.Status.STABLE;
    }
}

