/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import java.util.function.Consumer;

public class AnnihilationReaction
extends EffectReaction {
    public AnnihilationReaction(String alias, Power p1, Power p2, Consumer<Reactor> function) {
        super(alias, function, 0);
        this.reagents.put(p1, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
        this.reagents.put(p2, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
    }

    @Override
    public Reaction.Status conditionsMet(Reactor reactor) {
        if (super.conditionsMet(reactor) == Reaction.Status.REACTING) {
            if (reactor.getTotalPowerLevel() > WorldSpecificValues.ANNIHILATION_THRESHOLD.get()) {
                return Reaction.Status.REACTING;
            }
            return Reaction.Status.POWER_TOO_WEAK;
        }
        return Reaction.Status.STABLE;
    }

    @Override
    public String toString() {
        return super.toString() + " - annihilation reaction";
    }
}

