/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcomeTypes;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class FloatOneToValueFormulaOutcome
extends FormulaOutcome
implements FloatFormulaOutcome {
    final ResourceLocation power;
    final int min_power;
    final int max_power;
    final float value;
    public static final MapCodec<FloatOneToValueFormulaOutcome> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("power").forGetter(FloatOneToValueFormulaOutcome::power), (App)Codec.INT.fieldOf("min_power").forGetter(FloatOneToValueFormulaOutcome::getMinPower), (App)Codec.INT.fieldOf("max_power").forGetter(FloatOneToValueFormulaOutcome::getMaxPower), (App)Codec.FLOAT.fieldOf("value").forGetter(FloatOneToValueFormulaOutcome::getValue)).apply((Applicative)instance, FloatOneToValueFormulaOutcome::new));

    public FloatOneToValueFormulaOutcome(ResourceLocation power, int threshold, int max_power, float value) {
        this.power = power;
        this.min_power = threshold;
        this.max_power = max_power;
        this.value = value;
    }

    public int getMinPower() {
        return this.min_power;
    }

    public int getMaxPower() {
        return this.max_power;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public ResourceLocation power() {
        return this.power;
    }

    @Override
    public MapCodec<? extends FormulaOutcome> type() {
        return (MapCodec)FormulaOutcomeTypes.ONE_TO_VALUE_FLOAT.get();
    }

    @Override
    public float calculate(Map<Power, Integer> formula) {
        Power power = (Power)Powers.POWER_REGISTRY.get(this.power());
        if (formula.containsKey(power) && formula.get(power) > this.getMinPower()) {
            int provided_power = Math.min(formula.get(power) - this.min_power, this.max_power - this.min_power);
            float power_proportion = (float)provided_power / (float)(this.max_power - this.min_power);
            return (this.getValue() - 1.0f) * power_proportion + 1.0f;
        }
        return 1.0f;
    }
}

