/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.serialization.Codec;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.formula.PropertyFormulaRequirements;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public abstract class MaterialProperty<T> {
    public boolean requirementsMet(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_REGISTRY.getKey((Object)this);
        assert (id != null);
        Optional holder = MaterialProperties.PROPERTY_REGISTRY.getHolder(id);
        if (holder.isEmpty()) {
            throw new RuntimeException("Can't retrieve the material property registry from location " + String.valueOf(id));
        }
        PropertyFormulaRequirements requirement_map = (PropertyFormulaRequirements)((Holder.Reference)holder.get()).getData(ReactiveDataMaps.PROPERTY_FORMULA_MAP);
        if (requirement_map == null) {
            ReactiveMod.LOGGER.error("No requirement map has been defined for {}", (Object)id);
            return false;
        }
        for (PropertyFormulaRequirements.Part requirement : requirement_map.requirements()) {
            Power power = (Power)Powers.POWER_REGISTRY.get(requirement.power_id());
            if (power == null) {
                ReactiveMod.LOGGER.error("Invalid power {} in requirement map for {}", (Object)requirement.power_id(), (Object)id);
                return false;
            }
            if (formula.containsKey(power) && formula.get(power) >= requirement.lowBound(id)) continue;
            return false;
        }
        return true;
    }

    public abstract T instance(Map<Power, Integer> var1);

    public abstract Codec<T> codec();
}

