/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.util.Color;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class Material {
    private final Reference2ObjectMap<MaterialProperty<?>, Object> properties;
    private String custom_name;
    private final Optional<Formula> original_formula;
    private Optional<Discoverer> discoverer = Optional.empty();
    private Optional<String> notes = Optional.empty();
    private static final Codec<Map<MaterialProperty<?>, Object>> PROPERTIES_CODEC = Codec.dispatchedMap((Codec)MaterialProperties.PROPERTY_REGISTRY.byNameCodec(), MaterialProperty::codec);
    public static final Codec<Material> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PROPERTIES_CODEC.fieldOf("properties").forGetter(Material::properties), (App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(Material::customNameRaw), (App)Formula.CODEC.optionalFieldOf("original_formula").forGetter(Material::getOriginalFormula), (App)Discoverer.CODEC.optionalFieldOf("discoverer").forGetter(Material::discoverer), (App)Codec.STRING.optionalFieldOf("notes").forGetter(Material::getNotes)).apply((Applicative)instance, Material::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Material> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    private static final int POWER_SAME_THRESHOLD = 100;

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name, Optional<Formula> original_formula, Optional<Discoverer> discoverer, Optional<String> notes) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = original_formula;
        this.discoverer = discoverer;
        this.notes = notes;
    }

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name, Optional<Formula> original_formula) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = original_formula;
    }

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = Optional.empty();
    }

    public Optional<String> getNotes() {
        return this.notes;
    }

    public static Material empty() {
        return new Material(Map.of(), "");
    }

    private String customNameRaw() {
        return this.custom_name;
    }

    public Optional<Formula> getOriginalFormula() {
        return this.original_formula;
    }

    private Optional<Discoverer> discoverer() {
        return this.discoverer;
    }

    public boolean has(MaterialProperty<?> type) {
        return this.properties.containsKey(type);
    }

    public <T> T get(MaterialProperty<T> type) {
        return (T)this.properties.get(type);
    }

    public <T> T getOrDefault(MaterialProperty<T> key, T default_value) {
        if (this.has(key)) {
            return this.get(key);
        }
        return default_value;
    }

    public Map<MaterialProperty<?>, Object> properties() {
        return this.properties;
    }

    public String toString() {
        DataResult result = CODEC.encode((Object)this, (DynamicOps)NbtOps.INSTANCE, null);
        return ((Tag)result.getOrThrow()).getAsString();
    }

    public Component getNameComponent() {
        if (this.custom_name.isEmpty()) {
            return Component.translatable((String)"block.reactive.undiscovered_material");
        }
        return Component.literal((String)this.custom_name);
    }

    public void setName(String name) {
        this.custom_name = name;
    }

    public void setDiscoverer(Player player) {
        long timestamp = this.discoverer.isPresent() ? this.discoverer.get().discovery_timestamp() : System.currentTimeMillis();
        this.discoverer = Optional.of(new Discoverer(player.getUUID(), player.getName().getString(), timestamp));
    }

    public boolean wasDiscovered() {
        return this.discoverer.isPresent();
    }

    public Player getDiscoverer(Level level) {
        return this.discoverer.map(d -> level.getPlayerByUUID(d.uuid)).orElse(null);
    }

    public boolean playerDiscoveredThis(Player player) {
        return this.discoverer.isPresent() && this.discoverer.get().uuid.equals(player.getUUID());
    }

    protected <T> void set(MaterialProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public boolean formulaMatches(@NotNull Formula formula) {
        if (this.original_formula.isEmpty()) {
            return false;
        }
        if (!this.original_formula.get().base_material().is((ResourceKey)formula.base_material().unwrap().orThrow())) {
            return false;
        }
        for (Power power : formula.powers().keySet()) {
            if (this.original_formula.get().powers().containsKey(power)) continue;
            return false;
        }
        for (Power power : this.original_formula.get().powers().keySet()) {
            if (!formula.powers().containsKey(power)) {
                return false;
            }
            if (Math.abs(formula.powers().get(power) - this.original_formula.get().powers().get(power)) <= 100) continue;
            return false;
        }
        return true;
    }

    public void setNotes(String notes) {
        if (notes.isEmpty()) {
            this.notes = Optional.empty();
            return;
        }
        this.notes = Optional.of(notes);
    }

    public Component getDiscovererName(Level level) {
        if (!this.wasDiscovered()) {
            return Component.empty();
        }
        Player player = this.getDiscoverer(level);
        if (player == null) {
            return Component.translatable((String)"text.reactive.discovered_by").withStyle(ChatFormatting.LIGHT_PURPLE).append(this.discoverer().get().name);
        }
        this.setDiscoverer(player);
        return Component.translatable((String)"text.reactive.discovered_by").withStyle(ChatFormatting.LIGHT_PURPLE).append(player.getName());
    }

    public long getDiscoveryTime() {
        return this.discoverer.map(Discoverer::discovery_timestamp).orElse(0L);
    }

    public MutableComponent formulaComponent() {
        Optional<Formula> possible_formula = this.getOriginalFormula();
        if (possible_formula.isEmpty()) {
            return Component.translatable((String)"ui.reactive.no_formula");
        }
        Formula original_formula = possible_formula.get();
        Map<Power, Integer> original_powers = original_formula.powers();
        if (original_powers.isEmpty()) {
            return Component.translatable((String)"ui.reactive.no_formula");
        }
        ArrayList<Object> formula_lines = new ArrayList<Object>();
        formula_lines.add(((Item)original_formula.base_material().value()).getName(((Item)original_formula.base_material().value()).getDefaultInstance()));
        for (Power power : original_powers.keySet().stream().sorted(Comparator.comparing(original_powers::get)).toList().reversed()) {
            formula_lines.add(Component.literal((String)(power.getName() + ": " + Math.round((double)original_powers.get(power).intValue() / 16.0) + "%")).withColor(Material.shouldColorizeAgainstBlack(power.getColor()) ? power.getColor().hex() : 0xFFFFFF));
        }
        MutableComponent readout_message = Component.empty();
        for (int i = 0; i < formula_lines.size(); ++i) {
            readout_message.append((Component)formula_lines.get(i));
            if (i >= formula_lines.size() - 1) continue;
            readout_message.append("\n");
        }
        return readout_message;
    }

    private static boolean shouldColorizeAgainstBlack(Color color) {
        int threshold = 90;
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return false;
        }
        return (Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false && (color.red > threshold || color.green > threshold || color.blue > threshold);
    }

    public record Discoverer(UUID uuid, String name, long discovery_timestamp) {
        public static final Codec<Discoverer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(Discoverer::uuid), (App)Codec.STRING.fieldOf("name").forGetter(Discoverer::name), (App)Codec.LONG.optionalFieldOf("discovery_timestamp", (Object)0L).forGetter(Discoverer::discovery_timestamp)).apply((Applicative)instance, Discoverer::new));
    }
}

