/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.serialization.Codec;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.IntegerFormulaOutcome;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class IntMaterialProperty
extends MaterialProperty<Integer> {
    @Override
    public Integer instance(Map<Power, Integer> formula) {
        Object e;
        ResourceLocation id = MaterialProperties.PROPERTY_REGISTRY.getKey((Object)this);
        assert (id != null);
        Optional holder = MaterialProperties.PROPERTY_REGISTRY.getHolder(id);
        if (holder.isEmpty()) {
            throw new RuntimeException("Can't retrieve the material property registry from location " + String.valueOf(id));
        }
        List outcomes = (List)((Holder.Reference)holder.get()).getData(ReactiveDataMaps.FORMULA_OUTCOME_MAP);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to 0", (Object)id);
            return 0;
        }
        if (outcomes.size() > 1) {
            ReactiveMod.LOGGER.error("Integer outcome maps do not support multiple outcomes in the list, ignoring all but the first.");
        }
        if (!((e = outcomes.getFirst()) instanceof IntegerFormulaOutcome)) {
            ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, defaulting to 0", (Object)id);
            return 0;
        }
        IntegerFormulaOutcome outcome = (IntegerFormulaOutcome)e;
        return outcome.calculate(formula);
    }

    @Override
    public Codec<Integer> codec() {
        return Codec.INT;
    }
}

