/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import com.mojang.serialization.Codec;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.registration.ReactiveDataMaps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;

public class FloatMaterialProperty
extends MaterialProperty<Float> {
    @Override
    public Float instance(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_REGISTRY.getKey((Object)this);
        assert (id != null);
        Optional holder = MaterialProperties.PROPERTY_REGISTRY.getHolder(id);
        if (holder.isEmpty()) {
            throw new RuntimeException("Can't retrieve the material property registry from location " + String.valueOf(id));
        }
        List outcomes = (List)((Holder.Reference)holder.get()).getData(ReactiveDataMaps.FORMULA_OUTCOME_MAP);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to 0.0", (Object)id);
            return Float.valueOf(0.0f);
        }
        float value = 1.0f;
        for (FormulaOutcome outcome : outcomes) {
            if (!(outcome instanceof FloatFormulaOutcome)) {
                ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, skipping.", (Object)id);
                continue;
            }
            FloatFormulaOutcome float_outcome = (FloatFormulaOutcome)((Object)outcome);
            value *= float_outcome.calculate(formula);
        }
        return Float.valueOf(value);
    }

    @Override
    public Codec<Float> codec() {
        return Codec.FLOAT;
    }
}

