/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.registration.ReactiveCriterionTriggers;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ReactionTrigger
extends SimpleCriterionTrigger<ReactionTriggerInstance> {
    public static void triggerForNearbyPlayers(ServerLevel l, String alias, BlockPos center, int range) {
        List nearby_players = l.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)center), (double)range, (double)range, (double)range));
        for (Player p : nearby_players) {
            ((ReactionTrigger)((Object)ReactiveCriterionTriggers.REACTION.get())).trigger((ServerPlayer)p, alias);
        }
    }

    public static void triggerPerfectForNearbyPlayers(ServerLevel l, String alias, BlockPos center, int range) {
        List nearby_players = l.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)center), (double)range, (double)range, (double)range));
        for (Player p : nearby_players) {
            ((ReactionTrigger)((Object)ReactiveCriterionTriggers.PERFECT_REACTION.get())).trigger((ServerPlayer)p, alias);
        }
    }

    public Codec<ReactionTriggerInstance> codec() {
        return ReactionTriggerInstance.CODEC;
    }

    public Criterion<ReactionTriggerInstance> instance(String reaction_alias) {
        return this.createCriterion((CriterionTriggerInstance)new ReactionTriggerInstance(reaction_alias));
    }

    public void trigger(ServerPlayer player, String running_reaction) {
        this.trigger(player, instance -> instance.matches(running_reaction));
    }

    public record ReactionTriggerInstance(String reaction_alias) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<ReactionTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("reaction_alias").forGetter(ReactionTriggerInstance::reaction_alias)).apply((Applicative)instance, ReactionTriggerInstance::new));

        public boolean matches(String running_reaction) {
            return running_reaction.equals(this.reaction_alias);
        }

        public void validate(CriterionValidator validator) {
            super.validate(validator);
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }
    }
}

