/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlagTrigger
extends SimpleCriterionTrigger<FlagTriggerInstance> {
    public static void triggerForNearbyPlayers(ServerLevel l, FlagTrigger crit, BlockPos center, int range) {
        List nearby_players = l.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)center), (double)range, (double)range, (double)range));
        for (Player p : nearby_players) {
            crit.trigger((ServerPlayer)p);
        }
    }

    public Codec<FlagTriggerInstance> codec() {
        return FlagTriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        this.trigger(player, FlagTriggerInstance::matches);
    }

    public static class FlagTriggerInstance
    implements SimpleCriterionTrigger.SimpleInstance {
        public static final Codec<FlagTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(FlagTriggerInstance::player)).apply((Applicative)instance, FlagTriggerInstance::new));

        public FlagTriggerInstance(Optional<ContextAwarePredicate> ignored) {
        }

        public boolean matches() {
            return true;
        }

        public void validate(CriterionValidator validator) {
            super.validate(validator);
        }

        public Optional<ContextAwarePredicate> player() {
            return Optional.empty();
        }
    }
}

