/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.network.messages.NotifyServerAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.util.IOPool;
import com.ldtteam.structurize.util.JavaUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public class ClientStructurePackLoader {
    public static volatile ClientLoadingState loadingState = ClientLoadingState.LOADING;

    public static void onClientLoading() {
        ArrayList<Path> modPaths = new ArrayList<Path>();
        ArrayList<String> modList = new ArrayList<String>();
        for (IModInfo mod : ModList.get().getMods()) {
            modPaths.add(mod.getOwningFile().getFile().findResource(new String[]{"blueprints", mod.getModId()}));
            modList.add(mod.getModId());
        }
        if (Minecraft.getInstance() == null) {
            return;
        }
        Path gameFolder = Minecraft.getInstance().gameDirectory.toPath();
        IOPool.execute(() -> {
            Stream<Path> paths;
            for (Path modPath : modPaths) {
                try {
                    paths = Files.list(modPath);
                    try {
                        paths.forEach(element -> StructurePacks.discoverPackAtPath(element, true, modList, false, modPath.toString().split("/")[1]));
                    }
                    finally {
                        if (paths == null) continue;
                        paths.close();
                    }
                }
                catch (IOException e) {
                    Log.getLogger().warn("Failed loading packs from mod path: " + modPath.toString());
                }
            }
            try {
                Path clientPackPath;
                Path outputPath = gameFolder.resolve("blueprints");
                if (!Files.exists(outputPath, new LinkOption[0])) {
                    Files.createDirectory(outputPath, new FileAttribute[0]);
                }
                if (!Files.exists(clientPackPath = outputPath.resolve(Minecraft.getInstance().getUser().getName().toLowerCase(Locale.US)), new LinkOption[0])) {
                    Files.createDirectory(clientPackPath, new FileAttribute[0]);
                    Files.createDirectory(clientPackPath.resolve("scans"), new FileAttribute[0]);
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("version", (Number)1);
                    jsonObject.addProperty("pack-format", (Number)1);
                    jsonObject.addProperty("desc", "This is your local Structurepack. This is where all your scans go.");
                    JsonArray authorArray = new JsonArray();
                    authorArray.add(Minecraft.getInstance().getUser().getName());
                    jsonObject.add("authors", (JsonElement)authorArray);
                    JsonArray modsArray = new JsonArray();
                    modsArray.add("structurize");
                    jsonObject.add("mods", (JsonElement)modsArray);
                    jsonObject.addProperty("name", Minecraft.getInstance().getUser().getName());
                    jsonObject.addProperty("icon", "");
                    Files.write(clientPackPath.resolve("pack.json"), jsonObject.toString().getBytes(), new OpenOption[0]);
                }
                paths = Files.list(outputPath);
                try {
                    paths.forEach(element -> StructurePacks.discoverPackAtPath(element, false, modList, false, "Local"));
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
            catch (IOException e) {
                Log.getLogger().warn("Failed loading packs from main folder path: " + gameFolder.toString());
            }
            Log.getLogger().warn("Finished discovering Client Structure packs");
            loadingState = ClientLoadingState.FINISHED_LOADING;
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().level != null && loadingState == ClientLoadingState.FINISHED_LOADING) {
            if (Minecraft.getInstance().isSingleplayer()) {
                loadingState = ClientLoadingState.FINISHED_SYNCING;
                StructurePacks.setFinishedLoading();
                if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                    StructurePacks.selectedPack = ClientStructurePackLoader.getRandomPack();
                }
                return;
            }
            loadingState = ClientLoadingState.SYNCING;
            new NotifyServerAboutStructurePacksMessage(StructurePacks.getPackMetas()).sendToServer();
        } else if (Minecraft.getInstance().level == null && (loadingState == ClientLoadingState.SYNCING || loadingState == ClientLoadingState.FINISHED_SYNCING)) {
            Log.getLogger().warn("Client logged off. Resetting Pack Meta and Reloading State");
            loadingState = ClientLoadingState.LOADING;
            StructurePacks.clearPacks();
            RenderingCache.clear();
            ClientStructurePackLoader.onClientLoading();
        }
    }

    public static void onServerSyncAttempt(Map<String, Double> serverStructurePacks) {
        new SyncSettingsToServer().sendToServer();
        if (serverStructurePacks.isEmpty()) {
            loadingState = ClientLoadingState.FINISHED_SYNCING;
            StructurePacks.setFinishedLoading();
            if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                StructurePacks.selectedPack = ClientStructurePackLoader.getRandomPack();
            }
            return;
        }
        if (serverStructurePacks.containsKey(Minecraft.getInstance().player.getGameProfile().getName())) {
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"structurize.pack.equaluser.error"));
        }
        boolean needsChanges = false;
        for (StructurePackMeta pack : StructurePacks.getPackMetas()) {
            if (pack.isImmutable()) continue;
            double version = serverStructurePacks.getOrDefault(pack.getName(), -1.0);
            if (version == -1.0) {
                if (((Boolean)((ServerConfiguration)Structurize.getConfig().getServer()).allowPlayerSchematics.get()).booleanValue()) continue;
                StructurePacks.disablePack(pack.getName());
                continue;
            }
            if (version == pack.getVersion()) continue;
            StructurePacks.disablePack(pack.getName());
            needsChanges = true;
        }
        for (String packKey : serverStructurePacks.keySet()) {
            if (StructurePacks.hasPack(packKey)) continue;
            needsChanges = true;
            break;
        }
        if (!needsChanges) {
            loadingState = ClientLoadingState.FINISHED_SYNCING;
            if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                StructurePacks.selectedPack = ClientStructurePackLoader.getRandomPack();
            }
            StructurePacks.setFinishedLoading();
        }
    }

    public static void onStructurePackTransfer(String packName, ByteBuf payload, boolean eol) {
        Log.getLogger().warn("Received Structure pack from the Server: " + packName);
        IOPool.execute(() -> {
            StructurePackMeta pack = StructurePacks.disablePack(packName);
            if (pack != null && !pack.isImmutable() && !JavaUtils.deleteDirectory(pack.getPath())) {
                Log.getLogger().warn("Error trying to delete pack: ");
            }
            try (ZipInputStream zis = new ZipInputStream((InputStream)new ByteBufInputStream(payload));){
                ZipEntry zipEntry = zis.getNextEntry();
                Path structureFolder = Minecraft.getInstance().gameDirectory.toPath().resolve("blueprints");
                JavaUtils.deleteDirectory(structureFolder.resolve(packName));
                Path rootPath = Files.createDirectory(structureFolder.resolve(packName), new FileAttribute[0]);
                while (zipEntry != null) {
                    boolean isDirectory = zipEntry.isDirectory();
                    Path newPath = ClientStructurePackLoader.zipSlipProtect(zipEntry, rootPath);
                    if (isDirectory) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                    } else {
                        if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                ArrayList<String> modList = new ArrayList<String>();
                for (IModInfo mod : ModList.get().getMods()) {
                    modList.add(mod.getModId());
                }
                StructurePacks.discoverPackAtPath(rootPath, true, modList, false, "Local");
            }
            catch (IOException ex) {
                Log.getLogger().error("Unable to read datapack from zip", (Throwable)ex);
            }
            payload.release();
            if (eol) {
                loadingState = ClientLoadingState.FINISHED_SYNCING;
                StructurePacks.setFinishedLoading();
                StructurePacks.selectedPack = ClientStructurePackLoader.getRandomPack();
            }
        });
    }

    public static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir.normalize())) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public static void handleSaveScanMessage(CompoundTag compound, String fileName, HolderLookup.Provider provider) {
        String packName = Minecraft.getInstance().getUser().getName().toLowerCase(Locale.US);
        StructurePacks.selectedPack = StructurePacks.getStructurePack(Minecraft.getInstance().getUser().getName());
        RenderingCache.getOrCreateBlueprintPreviewData("blueprint").setBlueprintFuture(StructurePacks.storeBlueprint(packName, compound, Minecraft.getInstance().gameDirectory.toPath().resolve("blueprints").resolve(Minecraft.getInstance().getUser().getName().toLowerCase(Locale.US)).resolve("scans").resolve(fileName), provider));
        RenderingCache.getOrCreateBlueprintPreviewData("blueprint").setPos(null);
        Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"Scan successfully saved as %s", (Object[])new Object[]{fileName}), false);
    }

    public static StructurePackMeta getRandomPack() {
        Collection<StructurePackMeta> coll = StructurePacks.getPackMetas();
        int num = (int)(Math.random() * (double)coll.size());
        for (StructurePackMeta packMeta : coll) {
            if (--num >= 0) continue;
            return packMeta;
        }
        return null;
    }

    public static enum ClientLoadingState {
        LOADING,
        FINISHED_LOADING,
        SYNCING,
        FINISHED_SYNCING;

    }
}

