/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.items.ItemTagTool;
import com.ldtteam.structurize.items.ModItems;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SetTagInTool
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"set_tag_in_tool", SetTagInTool::new);
    private final String tag;
    private final int slot;

    protected SetTagInTool(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.tag = buf.readUtf(Short.MAX_VALUE);
        this.slot = buf.readInt();
    }

    public SetTagInTool(String tag, int slot) {
        super(TYPE);
        this.slot = slot;
        this.tag = tag;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.tag);
        buf.writeInt(this.slot);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.tagtool.creative_only"), false);
            return;
        }
        ItemStack stack = player.getInventory().getItem(this.slot);
        if (stack.getItem() == ModItems.tagTool.get()) {
            ItemTagTool.TagData.updateItemStack(stack, tags -> tags.setCurrentTag(this.tag));
        }
    }
}

