/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.ReplaceBlockOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ReplaceBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"replace_block", ReplaceBlockMessage::new);
    private final BlockPos from;
    private final BlockPos to;
    private final ItemStack blockFrom;
    private final ItemStack blockTo;
    private final int pct;

    protected ReplaceBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.from = buf.readBlockPos();
        this.to = buf.readBlockPos();
        this.blockTo = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.blockFrom = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.pct = buf.readInt();
    }

    public ReplaceBlockMessage(BlockPos pos1, BlockPos pos2, ItemStack blockFrom, ItemStack blockTo, int pct) {
        super(TYPE);
        this.from = pos1;
        this.to = pos2;
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.pct = pct;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.from);
        buf.writeBlockPos(this.to);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.blockTo);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)this.blockFrom);
        buf.writeInt(this.pct);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        Manager.addToQueue(new ReplaceBlockOperation((Player)player, this.from, this.to, this.blockFrom, this.blockTo, this.pct));
    }
}

