/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.fluid;

import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class MapleSap
extends BaseFlowingFluid {
    protected MapleSap() {
        super(new BaseFlowingFluid.Properties(TreeRegistrator.MAPLE_SAP_TYPE, TreeRegistrator.MAPLE_SAP, TreeRegistrator.MAPLE_SAP_FLOWING).bucket(TreeRegistrator.MAPLE_SAP_BUCKET));
    }

    public static class Source
    extends MapleSap {
        public boolean isSource(FluidState pState) {
            return true;
        }

        public int getAmount(FluidState pState) {
            return 8;
        }
    }

    public static class Flowing
    extends MapleSap {
        public boolean isSource(FluidState pState) {
            return false;
        }

        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{BlockStateProperties.LEVEL_FLOWING});
        }

        public int getAmount(FluidState pState) {
            return (Integer)pState.getValue((Property)BlockStateProperties.LEVEL_FLOWING);
        }
    }
}

