/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.init.network;

import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.network.TraitEffectToClient;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ClientSyncHandler {
    public static void handleChunkUpdate(ResourceLocation id, int x, int z, CompoundTag tag) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || !level.dimension().location().equals((Object)id)) {
            return;
        }
        Optional<ChunkCapHolder> cap = ChunkDifficulty.at((Level)level, x, z);
        if (cap.isEmpty()) {
            return;
        }
        ChunkDifficulty diff = cap.get().cap();
        new TagCodec((HolderLookup.Provider)level.registryAccess()).fromTag(tag, ChunkDifficulty.class, (Object)diff);
    }

    public static void handleEffect(TraitEffectToClient packet) {
        packet.effect().func.get().accept(packet);
    }

    public static void triggerUndying(TraitEffectToClient packet) {
        Entity entity;
        if (!((Boolean)LHConfig.CLIENT.showUndyingParticles.get()).booleanValue()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && packet.id() >= 0 && (entity = level.getEntity(packet.id())) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Minecraft.getInstance().particleEngine.createTrackingEmitter((Entity)entity2, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
            entity2.level().playLocalSound(entity2.getX(), entity2.getY(), entity2.getZ(), SoundEvents.TOTEM_USE, entity2.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    public static void triggerAura(TraitEffectToClient packet) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && packet.id() >= 0 && (entity = level.getEntity(packet.id())) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            double radius = ((Integer)LHConfig.SERVER.killerAuraRange.get()).intValue();
            Vec3 center = entity2.position();
            for (int i = 0; i < 100; ++i) {
                float tpi = (float)Math.PI * 2;
                Vec3 v0 = new Vec3(0.0, radius, 0.0);
                v0 = v0.xRot(tpi / 4.0f).yRot(level.getRandom().nextFloat() * tpi);
                level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, 0.0, 0.0, 0.0);
            }
            entity2.level().playLocalSound(entity2.getX(), entity2.getY(), entity2.getZ(), SoundEvents.FIRECHARGE_USE, entity2.getSoundSource(), 3.0f, 1.0f, false);
        }
    }
}

