/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.init.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.compat.jei.ITraitLootRecipe;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.loot.MobCapLootCondition;
import dev.xkmc.l2hostility.init.loot.MobHealthCondition;
import dev.xkmc.l2hostility.init.loot.PlayerHasItemCondition;
import dev.xkmc.l2hostility.init.loot.TraitLootCondition;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2library.util.GenericItemStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraitLootModifier
extends LootModifier
implements ITraitLootRecipe {
    public static final MapCodec<TraitLootModifier> CODEC = RecordCodecBuilder.mapCodec(i -> TraitLootModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)LHTraits.TRAITS.get().byNameCodec().optionalFieldOf("trait").forGetter(e -> Optional.ofNullable(e.trait)), (App)Codec.DOUBLE.fieldOf("chance").forGetter(e -> e.chance), (App)Codec.DOUBLE.fieldOf("rankBonus").forGetter(e -> e.rankBonus), (App)ItemStack.CODEC.fieldOf("result").forGetter(e -> e.result))).apply((Applicative)i, TraitLootModifier::new));
    @Nullable
    public final MobTrait trait;
    public final double chance;
    public final double rankBonus;
    public final ItemStack result;

    public TraitLootModifier(MobTrait trait, double chance, double rankBonus, ItemStack result, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.trait = trait;
        this.chance = chance;
        this.rankBonus = rankBonus;
        this.result = result;
    }

    private TraitLootModifier(LootItemCondition[] conditionsIn, Optional<MobTrait> trait, double chance, double rankBonus, ItemStack result) {
        super(conditionsIn);
        this.trait = trait.orElse(null);
        this.chance = chance;
        this.rankBonus = rankBonus;
        this.result = result;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> list, LootContext context) {
        Object object = context.getParam(LootContextParams.THIS_ENTITY);
        if (object instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)object;
            Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)le);
            if (opt.isPresent() && !le.getType().is(LHTagGen.NO_DROP)) {
                MobTraitCap cap = (MobTraitCap)((Object)opt.get());
                if (this.trait == null || cap.hasTrait(this.trait)) {
                    double factor = cap.dropRate;
                    if (context.hasParam(LootContextParams.LAST_DAMAGE_PLAYER)) {
                        Player player = (Player)context.getParam(LootContextParams.LAST_DAMAGE_PLAYER);
                        PlayerDifficulty pl = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
                        for (GenericItemStack<CurseCurioItem> stack : CurseCurioItem.getFromPlayer((LivingEntity)player)) {
                            factor *= ((CurseCurioItem)stack.item()).getLootFactor(stack.stack(), pl, cap);
                        }
                    }
                    int lv = this.trait == null ? 0 : cap.getTraitLevel(this.trait);
                    double rate = this.chance + (double)lv * this.rankBonus;
                    int count = 0;
                    int i = 0;
                    while ((double)i < (double)this.result.getCount() * factor) {
                        if (context.getRandom().nextDouble() < rate) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count > 0) {
                        ItemStack ans = this.result.copy();
                        if (((Boolean)LHConfig.SERVER.nidhoggurCapAtItemMaxStack.get()).booleanValue()) {
                            count = Math.min(count, ans.getMaxStackSize());
                        }
                        ans.setCount(count);
                        list.add((Object)ans);
                    }
                }
            }
        }
        return list;
    }

    public MapCodec<TraitLootModifier> codec() {
        return CODEC;
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    @Override
    public List<ItemStack> getResults() {
        return List.of(this.result);
    }

    @Override
    public List<ItemStack> getCurioRequired() {
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        if (((Boolean)LHConfig.SERVER.disableHostilityLootCurioRequirement.get()).booleanValue()) {
            return ans;
        }
        for (LootItemCondition c : this.getConditions()) {
            if (!(c instanceof PlayerHasItemCondition)) continue;
            PlayerHasItemCondition item = (PlayerHasItemCondition)c;
            ans.add(item.item.getDefaultInstance());
        }
        return ans;
    }

    @Override
    public List<ItemStack> getInputs() {
        LinkedHashSet<MobTrait> set = new LinkedHashSet<MobTrait>();
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        if (this.trait != null) {
            set.add(this.trait);
        }
        for (LootItemCondition c : this.getConditions()) {
            if (!(c instanceof TraitLootCondition)) continue;
            TraitLootCondition cl = (TraitLootCondition)c;
            set.add(cl.trait);
        }
        for (MobTrait e : set) {
            ans.add(e.asItem().getDefaultInstance());
        }
        return ans;
    }

    @Override
    public boolean isValid() {
        if (this.trait == null) {
            return true;
        }
        if (this.trait.isBanned()) {
            return false;
        }
        int max = this.trait.getMaxLevel();
        for (LootItemCondition c : this.getConditions()) {
            if (!(c instanceof TraitLootCondition)) continue;
            TraitLootCondition cl = (TraitLootCondition)c;
            if (cl.trait.isBanned()) {
                return false;
            }
            if (cl.trait != this.trait || cl.minLevel <= max) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addTooltip(Consumer<Component> list) {
        int max = this.trait == null ? 0 : this.trait.getConfig().max_rank();
        int min = 1;
        int minLevel = 0;
        ArrayList<TraitLootCondition> other = new ArrayList<TraitLootCondition>();
        ArrayList<PlayerHasItemCondition> itemReq = new ArrayList<PlayerHasItemCondition>();
        ArrayList<MobHealthCondition> health = new ArrayList<MobHealthCondition>();
        for (LootItemCondition c : this.getConditions()) {
            if (c instanceof TraitLootCondition) {
                TraitLootCondition cl = (TraitLootCondition)c;
                if (cl.trait == this.trait) {
                    max = Math.min(max, cl.maxLevel);
                    min = Math.max(min, cl.minLevel);
                    continue;
                }
                other.add(cl);
                continue;
            }
            if (c instanceof MobCapLootCondition) {
                MobCapLootCondition cl = (MobCapLootCondition)c;
                minLevel = cl.minLevel;
                continue;
            }
            if (c instanceof PlayerHasItemCondition) {
                PlayerHasItemCondition cl = (PlayerHasItemCondition)c;
                itemReq.add(cl);
                continue;
            }
            if (!(c instanceof MobHealthCondition)) continue;
            MobHealthCondition cl = (MobHealthCondition)c;
            health.add(cl);
        }
        if (minLevel > 0) {
            list.accept((Component)LangData.LOOT_MIN_LEVEL.get(Component.literal((String)("" + minLevel)).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        for (MobHealthCondition e : health) {
            list.accept((Component)LangData.LOOT_MIN_HEALTH.get(Component.literal((String)("" + e.minHealth)).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        if (this.trait != null) {
            for (int lv = min; lv <= max; ++lv) {
                list.accept((Component)LangData.LOOT_CHANCE.get(Component.literal((String)(Math.round((this.chance + this.rankBonus * (double)lv) * 100.0) + "%")).withStyle(ChatFormatting.AQUA), this.trait.getDesc().withStyle(ChatFormatting.GOLD), Component.literal((String)("" + lv)).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            }
        } else {
            list.accept((Component)LangData.LOOT_NO_TRAIT.get(Component.literal((String)(Math.round(this.chance * 100.0) + "%")).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
        }
        for (TraitLootCondition c : other) {
            int cmin = Math.max(c.minLevel, 1);
            int cmax = Math.min(c.maxLevel, c.trait.getMaxLevel());
            String str = cmax == cmin ? "" + cmin : (cmax >= c.trait.getMaxLevel() ? cmin + "+" : cmin + "-" + cmax);
            list.accept((Component)LangData.LOOT_OTHER_TRAIT.get(c.trait.getDesc().withStyle(ChatFormatting.GOLD), Component.literal((String)str).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.RED));
        }
        for (PlayerHasItemCondition e : itemReq) {
            MutableComponent name = e.item.getDescription().copy().withStyle(ChatFormatting.LIGHT_PURPLE);
            list.accept((Component)LangData.TOOLTIP_JEI_REQUIRED.get(name).withStyle(ChatFormatting.YELLOW));
        }
    }
}

