/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.curio.curse.CurseOfWrath;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.loot.TraitLootModifier;
import dev.xkmc.l2hostility.init.network.LootDataToClient;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.mixin.NeoForgeEventHandlerAccessor;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="l2hostility", bus=EventBusSubscriber.Bus.GAME)
public class MobEvents {
    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent event) {
        Mob mob;
        LivingEntity credit;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (credit = (mob = (Mob)livingEntity).getKillCredit()) != null && CurioCompat.hasItemInCurio(credit, (Item)LHItems.CURSE_LUST.get())) {
            for (EquipmentSlot e : EquipmentSlot.values()) {
                mob.setDropChance(e, 1.0f);
            }
        }
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)event.getEntity());
        opt.ifPresent(cap -> cap.traitEvent((k, v) -> k.onDeath((int)v, event.getEntity(), event)));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMobDrop(LivingDropsEvent event) {
        LivingEntity mob = event.getEntity();
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
        if (opt.isEmpty()) {
            return;
        }
        MobTraitCap cap = (MobTraitCap)((Object)opt.get());
        if (cap.noDrop) {
            event.setCanceled(true);
            return;
        }
        LivingEntity killer = event.getEntity().getKillCredit();
        if (killer != null && CurioCompat.hasItemInCurio(killer, (Item)LHItems.NIDHOGGUR.get())) {
            double val = (Double)LHConfig.SERVER.nidhoggurDropFactor.get() * (double)cap.getLevel();
            int count = (int)val;
            if (event.getEntity().getRandom().nextDouble() < val - (double)count) {
                ++count;
            }
            ++count;
            for (ItemEntity stack : event.getDrops()) {
                int ans = stack.getItem().getCount() * count;
                if (((Boolean)LHConfig.SERVER.nidhoggurCapAtItemMaxStack.get()).booleanValue()) {
                    ans = Math.min(stack.getItem().getMaxStackSize(), ans);
                }
                stack.getItem().setCount(ans);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onExpDrop(LivingExperienceDropEvent event) {
        LivingEntity mob = event.getEntity();
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
        if (opt.isEmpty()) {
            return;
        }
        MobTraitCap cap = (MobTraitCap)((Object)opt.get());
        if (cap.noDrop) {
            event.setCanceled(true);
            return;
        }
        int exp = event.getDroppedExperience();
        int level = cap.getLevel();
        exp = (int)((double)exp * (1.0 + (Double)LHConfig.SERVER.expDropFactor.get() * (double)level));
        event.setDroppedExperience(exp);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPotionTest(MobEffectEvent.Applicable event) {
        MobEffectInstance ins = event.getEffectInstance();
        if (ins == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (CurioCompat.hasItemInCurio(entity, (Item)LHItems.CURSE_WRATH.get()) && CurseOfWrath.SET.contains(ins.getEffect())) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ArrayList<TraitLootModifier> list = new ArrayList<TraitLootModifier>();
        for (IGlobalLootModifier e : NeoForgeEventHandlerAccessor.callGetLootModifierManager().getAllLootMods()) {
            if (!(e instanceof TraitLootModifier)) continue;
            TraitLootModifier loot = (TraitLootModifier)e;
            list.add(loot);
        }
        LootDataToClient packet = LootDataToClient.of(list);
        if (event.getPlayer() == null) {
            L2Hostility.HANDLER.toAllClient((SimplePacketBase)packet);
        } else {
            L2Hostility.HANDLER.toClientPlayer((SimplePacketBase)packet, event.getPlayer());
        }
    }
}

