/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.init.reg.ench.EnchHolder;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DamageTypeWrapper;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.enchantments.HitTargetEnchantment;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2library.util.GenericItemStack;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.Tags;

public class LHAttackListener
implements AttackListener {
    private static final ResourceLocation SCALING = L2Hostility.loc("scaling");
    private static final ResourceLocation MASTER_IMMUNE = L2Hostility.loc("master_immune");

    private static boolean masterImmunity(DamageData event) {
        Mob mob;
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        MobTraitCap attacker = null;
        MobTraitCap target = null;
        LivingEntity livingEntity = event.getAttacker();
        if (livingEntity instanceof Mob) {
            mob = (Mob)livingEntity;
            attacker = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob).orElse(null);
        }
        if ((livingEntity = event.getTarget()) instanceof Mob) {
            mob = (Mob)livingEntity;
            target = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob).orElse(null);
        }
        Mob attackerMaster = null;
        Mob targetMaster = null;
        if (attacker != null && attacker.asMinion != null) {
            attackerMaster = attacker.asMinion.master;
            if (event.getTarget() == attackerMaster) {
                return true;
            }
        }
        if (target != null && target.asMinion != null) {
            targetMaster = target.asMinion.master;
            if (event.getAttacker() == targetMaster) {
                return true;
            }
        }
        if (attackerMaster != null && attackerMaster == targetMaster) {
            return true;
        }
        return target != null && target.isMasterProtected();
    }

    public boolean onAttack(DamageData.Attack event) {
        if (LHAttackListener.masterImmunity((DamageData)event)) {
            return true;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getTarget();
        boolean bypassInvul = source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
        boolean bypassMagic = source.is(DamageTypeTags.BYPASSES_EFFECTS);
        boolean magic = source.is(Tags.DamageTypes.IS_MAGIC);
        if (magic && !bypassInvul && !bypassMagic && CurioCompat.hasItemInCurio(target, (Item)LHItems.RING_DIVINITY.get())) {
            return true;
        }
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)target);
        if (opt.isPresent()) {
            for (Map.Entry<MobTrait, Integer> e : ((MobTraitCap)((Object)opt.get())).traits.entrySet()) {
                if (!e.getKey().onAttackedByOthers(e.getValue(), target, event)) continue;
                return true;
            }
        }
        return false;
    }

    public void onHurt(DamageData.Offence data) {
        Optional attOpt;
        LivingEntity target;
        DamageSource source = data.getSource();
        if (source.is(L2DamageTypes.NO_SCALE)) {
            return;
        }
        LivingEntity attacker = data.getAttacker();
        if (attacker == (target = data.getTarget())) {
            return;
        }
        Optional targetOpt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)target);
        if (targetOpt.isPresent()) {
            MobTraitCap cap = (MobTraitCap)((Object)targetOpt.get());
            for (EnchHolder e : LegacyEnchantment.findAll((ItemStack)data.getWeapon(), HitTargetEnchantment.class, (boolean)true)) {
                ((HitTargetEnchantment)e.val()).hitMob(target, cap, e.lv(), data);
            }
        }
        if (attacker != null && (attOpt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)attacker)).isPresent()) {
            MobTraitCap cap = (MobTraitCap)((Object)attOpt.get());
            if (!attacker.getType().is(LHTagGen.NO_SCALING)) {
                int lv = cap.getLevel();
                double factor = (Boolean)LHConfig.SERVER.exponentialDamage.get() != false ? Math.pow(1.0 + (Double)LHConfig.SERVER.damageFactor.get(), lv) - 1.0 : (double)lv * (Double)LHConfig.SERVER.damageFactor.get();
                EntityConfig.Config config = cap.getConfigCache(attacker);
                if (config != null) {
                    factor *= config.attackScale;
                }
                double old = factor;
                for (Map.Entry<MobTrait, Integer> ent : cap.traits.entrySet()) {
                    factor *= ent.getKey().modifyBonusDamage(source, old, ent.getValue());
                }
                data.addHurtModifier(DamageModifier.multTotal((float)(1.0f + (float)factor), (ResourceLocation)SCALING));
            }
            TraitEffectCache traitCache = new TraitEffectCache(target);
            cap.traitEvent((k, v) -> k.onHurtTarget((int)v, attacker, data, traitCache));
        }
        if (attacker != null) {
            for (GenericItemStack<CurseCurioItem> e : CurseCurioItem.getFromPlayer(attacker)) {
                ((CurseCurioItem)e.item()).onHurtTarget(e.stack(), attacker, data);
            }
        }
    }

    public void onHurtMaximized(DamageData.OffenceMax data) {
        LivingEntity target = data.getTarget();
        ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)target).ifPresent(cap -> cap.traitEvent((k, v) -> k.onHurtByMax((int)v, target, data)));
    }

    public void onDamage(DamageData.Defence data) {
        LivingEntity attacker;
        LivingEntity mob = data.getTarget();
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
        if (opt.isPresent()) {
            MobTraitCap cap2 = (MobTraitCap)((Object)opt.get());
            cap2.traitEvent((k, v) -> k.onDamaged((int)v, mob, data));
        }
        if ((attacker = data.getAttacker()) == null) {
            return;
        }
        TraitEffectCache traitCache = new TraitEffectCache(mob);
        ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)attacker).ifPresent(cap -> cap.traitEvent((k, v) -> k.onHurtTargetMax((int)v, attacker, (DamageData.OffenceMax)data, traitCache)));
        for (ItemStack e2 : CurioCompat.getItems(mob, e -> e.getItem() instanceof CurseCurioItem)) {
            Item item = e2.getItem();
            if (!(item instanceof CurseCurioItem)) continue;
            CurseCurioItem curse = (CurseCurioItem)item;
            curse.onDamage(e2, mob, data);
        }
        if (LHAttackListener.masterImmunity((DamageData)data)) {
            data.addDealtModifier(DamageModifier.nonlinearFinal((int)10432, e -> 0.0f, (ResourceLocation)MASTER_IMMUNE));
        }
    }

    public void onCreateSource(CreateSourceEvent event) {
        LivingEntity mob = event.getAttacker();
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
        opt.ifPresent(cap -> cap.traitEvent((k, v) -> k.onCreateSource((int)v, event.getAttacker(), event)));
        DamageTypeWrapper type = event.getResult();
        if (type == null) {
            return;
        }
        DamageTypeWrapper root = type.toRoot();
        if (root == L2DamageTypes.MOB_ATTACK || root == L2DamageTypes.PLAYER_ATTACK) {
            if (CurioCompat.hasItemInCurioOrSlot(mob, (Item)LHItems.IMAGINE_BREAKER.get())) {
                event.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
            }
            if (CurioCompat.hasItemInCurio(mob, (Item)LHItems.PLATINUM_STAR.get())) {
                event.enable((DamageState)DefaultDamageState.BYPASS_COOLDOWN);
            }
        }
    }
}

