/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class ClientGlowingHandler {
    private static int cacheTick;
    private static boolean cacheGlass;

    public static boolean isGlowing(Entity entity) {
        MobTraitCap cap;
        Optional opt;
        Mob mob;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity le = (LivingEntity)entity;
        if (le instanceof Mob && (mob = (Mob)le).getTags().contains("HostilityGlowing") && (opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob)).isPresent() && ((cap = (MobTraitCap)((Object)opt.get())).isSummoned() || cap.isMasterProtected())) {
            return true;
        }
        if (le.level().isClientSide()) {
            return ClientGlowingHandler.isGlowingImpl(le);
        }
        return false;
    }

    private static boolean playerHasGlass(Player player) {
        if (player.tickCount == cacheTick) {
            return cacheGlass;
        }
        cacheGlass = CurioCompat.hasItemInCurioOrSlot((LivingEntity)player, (Item)LHItems.DETECTOR_GLASSES.get());
        cacheTick = player.tickCount;
        return cacheGlass;
    }

    private static boolean isGlowingImpl(LivingEntity entity) {
        Player player = Proxy.getPlayer();
        if (player != null && ClientGlowingHandler.playerHasGlass(player)) {
            boolean glow = entity.isInvisible() || entity.isInvisibleTo(player);
            glow |= player.hasEffect(MobEffects.BLINDNESS);
            float hidden = (float)((Integer)LHConfig.CLIENT.glowingRangeHidden.get()).intValue() + entity.getBbWidth() * 2.0f;
            float near = (float)((Integer)LHConfig.CLIENT.glowingRangeNear.get()).intValue() + entity.getBbWidth() * 2.0f;
            double distSqr = entity.distanceToSqr((Entity)player);
            return distSqr <= (double)(near * near) || (glow |= player.hasEffect(MobEffects.DARKNESS)) && distSqr <= (double)(hidden * hidden);
        }
        return false;
    }

    @Nullable
    public static Integer getColor(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
            if (opt.isPresent()) {
                MobTraitCap cap = (MobTraitCap)((Object)opt.get());
                if (cap.isSummoned()) {
                    return 0xFF0000;
                }
                if (cap.isMasterProtected()) {
                    return 0xFFAA00;
                }
            }
        }
        return null;
    }
}

