/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.events.ClientEffectRenderEvents;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkClearRenderer;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MasterData;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.traits.EnchantmentDisabler;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2hostility", bus=EventBusSubscriber.Bus.GAME)
public class ClientEvents {
    private static boolean renderChunk = false;
    public static final List<Mob> MASTERS = new ArrayList<Mob>();

    @SubscribeEvent
    public static void addTooltip(ItemTooltipEvent event) {
        Level level = event.getContext().level();
        if (level == null) {
            return;
        }
        EnchantmentDisabler.modifyTooltip(event.getItemStack(), event.getToolTip(), level, event.getContext(), event.getFlags());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderNamePlate(RenderNameTagEvent event) {
        boolean needHover;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)entity;
        boolean bl = needHover = le.isInvisible() || (Boolean)LHConfig.CLIENT.showOnlyWhenHovered.get() != false;
        if (needHover && Minecraft.getInstance().crosshairPickEntity != le) {
            return;
        }
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)le);
        LocalPlayer player = Minecraft.getInstance().player;
        if (opt.isEmpty() || player == null) {
            return;
        }
        MobTraitCap cap = (MobTraitCap)((Object)opt.get());
        List<Component> list = cap.getTitle((Boolean)LHConfig.CLIENT.showLevelOverHead.get(), (Boolean)LHConfig.CLIENT.showTraitOverHead.get());
        int offset = list.size();
        float off = (float)((Double)LHConfig.CLIENT.overHeadRenderOffset.get()).doubleValue();
        Font.DisplayMode mode = player.hasLineOfSight(event.getEntity()) ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        for (Component e : list) {
            ClientEvents.renderNameTag(le, event, e, event.getPoseStack(), ((float)offset + off) * 0.2f, mode);
            --offset;
        }
    }

    protected static void renderNameTag(LivingEntity le, RenderNameTagEvent event, Component text, PoseStack pose, float offset, Font.DisplayMode mode) {
        int max;
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        double d0 = dispatcher.distanceToSqr((Entity)le);
        if (d0 > (double)((max = ((Integer)LHConfig.CLIENT.overHeadRenderDistance.get()).intValue()) * max)) {
            return;
        }
        int light = (Boolean)LHConfig.CLIENT.overHeadRenderFullBright.get() != false ? 0xF000F0 : event.getPackedLight();
        Vec3 vec3 = le.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, le.getViewYRot(event.getPartialTick()));
        if (vec3 == null) {
            vec3 = new Vec3(0.0, le.getBoundingBox().getYsize(), 0.0);
        }
        pose.pushPose();
        pose.translate(vec3.x, vec3.y + (double)offset, vec3.z);
        pose.mulPose(dispatcher.cameraOrientation());
        pose.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = pose.last().pose();
        Font font = event.getEntityRenderer().getFont();
        float f2 = -font.width((FormattedText)text) / 2;
        float f1 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        font.drawInBatch(text, f2, 0.0f, -1, false, matrix4f, event.getMultiBufferSource(), mode, j, light);
        pose.popPose();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        MASTERS.clear();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.tickCount % 2 == 0) {
            renderChunk = CurioCompat.hasItemInCurioOrSlot((LivingEntity)player, (Item)LHItems.DETECTOR_GLASSES.get()) && CurioCompat.hasItemInCurioOrSlot((LivingEntity)player, (Item)LHItems.DETECTOR.get());
        }
    }

    @SubscribeEvent
    public static void onLevelRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            Optional<ChunkCapHolder> opt = ChunkDifficulty.at(player.level(), player.blockPosition());
            if (opt.isEmpty()) {
                return;
            }
            if (!renderChunk) {
                return;
            }
            ChunkClearRenderer.render(event.getPoseStack(), (Player)player, opt.get(), event.getPartialTick().getGameTimeDeltaPartialTick(true));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            LevelRenderer renderer = event.getLevelRenderer();
            MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
            VertexConsumer cons = buffers.getBuffer(ClientEffectRenderEvents.get2DIcon((ResourceLocation)L2Hostility.loc("textures/entity/chain.png")));
            PoseStack pose = event.getPoseStack();
            pose.pushPose();
            Vec3 cam = event.getCamera().getPosition();
            pose.translate(-cam.x, -cam.y, -cam.z);
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                for (Mob e : MASTERS) {
                    if (!e.isAlive()) continue;
                    MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)e);
                    if (cap.asMaster == null) continue;
                    Vec3 p0 = e.position().add(0.0, (double)(e.getBbHeight() / 2.0f), 0.0);
                    for (MasterData.Minion minions : cap.asMaster.data) {
                        Mob m = minions.minion;
                        if (m == null || !m.isAlive()) continue;
                        MobTraitCap scap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)m);
                        if (scap.asMinion == null) continue;
                        Vec3 p1 = m.position().add(0.0, (double)(m.getBbHeight() / 2.0f), 0.0);
                        ClientEvents.renderLink(event.getPoseStack(), cons, p0, p1, scap.asMinion.protectMaster);
                    }
                }
            }
            pose.popPose();
        }
    }

    private static void renderLink(PoseStack pose, VertexConsumer cons, Vec3 p0, Vec3 p1, boolean protect) {
        Vec3 vec3 = p1.subtract(p0);
        float len = (float)vec3.length();
        if (len < 0.2f) {
            return;
        }
        pose.pushPose();
        pose.translate(p0.x, p0.y, p0.z);
        double d0 = vec3.horizontalDistance();
        pose.mulPose(Axis.YP.rotation((float)Mth.atan2((double)vec3.x, (double)vec3.z)));
        pose.mulPose(Axis.XP.rotation((float)(1.5707963267948966 - Mth.atan2((double)vec3.y, (double)d0))));
        float r = 0.125f;
        float off = protect ? 0.5f : 0.0f;
        ClientEvents.renderQuad(pose.last(), cons, 0.0f, len, -r, r, 0.0f, 0.0f, off, off + 0.25f, 0.0f, len);
        ClientEvents.renderQuad(pose.last(), cons, 0.0f, len, r, -r, 0.0f, 0.0f, off, off + 0.25f, 0.0f, len);
        ClientEvents.renderQuad(pose.last(), cons, 0.0f, len, 0.0f, 0.0f, -r, r, off + 0.25f, off + 0.5f, 0.0f, len);
        ClientEvents.renderQuad(pose.last(), cons, 0.0f, len, 0.0f, 0.0f, r, -r, off + 0.25f, off + 0.5f, 0.0f, len);
        pose.popPose();
    }

    private static void renderQuad(PoseStack.Pose entry, VertexConsumer vc, float y0, float y1, float x0, float x1, float z0, float z1, float u0, float u1, float v0, float v1) {
        ClientEvents.vertex(entry, vc, x0, y1, z0, u1, v0);
        ClientEvents.vertex(entry, vc, x0, y0, z0, u1, v1);
        ClientEvents.vertex(entry, vc, x1, y0, z1, u0, v1);
        ClientEvents.vertex(entry, vc, x1, y1, z1, u0, v0);
    }

    private static void vertex(PoseStack.Pose entry, VertexConsumer vc, float x, float y, float z, float u, float v) {
        vc.addVertex(entry.pose(), x, y, z).setUv(u, v).setNormal(entry, 0.0f, 1.0f, 0.0f);
    }
}

