/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.events;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapSyncToClient;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="l2hostility", bus=EventBusSubscriber.Bus.GAME)
public class CapabilityEvents {
    private static final Set<ChunkCapHolder> PENDING = new LinkedHashSet<ChunkCapHolder>();

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)entity2).ifPresent(e -> e.syncToPlayer(entity2, player));
            }
        }
    }

    private static boolean initMob(LivingEntity mob, MobSpawnType type) {
        if (((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)mob)) {
            Optional<ChunkCapHolder> opt;
            MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)mob);
            if (!mob.level().isClientSide() && !cap.isInitialized() && (opt = ChunkDifficulty.at(mob.level(), mob.blockPosition())).isPresent()) {
                cap.init(mob.level(), mob, opt.get());
                if (type == MobSpawnType.NATURAL && cap.shouldDiscard(mob)) {
                    return true;
                }
                if (type == MobSpawnType.SPAWNER) {
                    cap.dropRate = (Double)LHConfig.SERVER.dropRateFromSpawner.get();
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntitySpawn(FinalizeSpawnEvent event) {
        Mob mob = event.getEntity();
        if (CapabilityEvents.initMob((LivingEntity)mob, event.getSpawnType())) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent
    public static void livingTickEvent(EntityTickEvent.Post event) {
        Optional opt;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        if (mob.tickCount % 10 == 0) {
            if (Float.isNaN(mob.getHealth())) {
                mob.setHealth(0.0f);
            }
            if (Float.isNaN(mob.getAbsorptionAmount())) {
                mob.setAbsorptionAmount(0.0f);
            }
        }
        if ((opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob)).isEmpty() && !((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)mob)) {
            return;
        }
        MobTraitCap cap = opt.orElse((MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)mob));
        cap.tick(mob);
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        OwnableEntity own;
        LivingEntity livingEntity;
        LivingEntity mob = event.getEntity();
        if (mob.level().isClientSide()) {
            return;
        }
        LivingEntity killer = event.getEntity().getKillCredit();
        ServerPlayer player = null;
        if (killer instanceof ServerPlayer) {
            ServerPlayer pl;
            player = pl = (ServerPlayer)killer;
        } else if (killer instanceof OwnableEntity && (livingEntity = (own = (OwnableEntity)killer).getOwner()) instanceof ServerPlayer) {
            ServerPlayer pl;
            player = pl = (ServerPlayer)livingEntity;
        }
        Optional optCap = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob);
        if (optCap.isPresent()) {
            MobTraitCap cap = (MobTraitCap)((Object)optCap.get());
            if (killer != null) {
                cap.onKilled(mob, (Player)player);
            }
            if (player != null) {
                PlayerDifficulty playerDiff = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
                playerDiff.addKillCredit(player, cap);
                LevelChunk chunk = mob.level().getChunkAt(mob.blockPosition());
                new ChunkCapHolder(chunk, (ChunkDifficulty)((GeneralCapabilityHolder)LHMiscs.CHUNK.type()).getOrCreate((IAttachmentHolder)chunk)).addKillHistory((Player)player, mob, cap);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (ChunkCapHolder e : PENDING) {
            L2Hostility.toTrackingChunk(e.chunk(), ChunkCapSyncToClient.of(e));
        }
        PENDING.clear();
    }

    @SubscribeEvent
    public static void onStartTrackingChunk(ChunkWatchEvent.Sent event) {
        ChunkDifficulty opt = (ChunkDifficulty)((GeneralCapabilityHolder)LHMiscs.CHUNK.type()).getOrCreate((IAttachmentHolder)event.getChunk());
        L2Hostility.HANDLER.toClientPlayer((SimplePacketBase)ChunkCapSyncToClient.of(new ChunkCapHolder(event.getChunk(), opt)), event.getPlayer());
    }

    public static void markDirty(ChunkCapHolder chunk) {
        PENDING.add(chunk);
    }
}

