/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.legendary;

import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.item.traits.SealedItem;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RagnarokTrait
extends LegendaryTrait {
    private static boolean allowSeal(EntitySlotAccess access) {
        ResourceLocation rl;
        ItemStack stack = access.get();
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.is((Item)LHItems.SEAL.get())) {
            return false;
        }
        if (stack.is(LHTagGen.NO_SEAL)) {
            return false;
        }
        if (!((Boolean)LHConfig.SERVER.ragnarokSealBackpack.get()).booleanValue() && (rl = BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toString().contains("backpack")) {
            return false;
        }
        if (!((Boolean)LHConfig.SERVER.ragnarokSealSlotAdder.get()).booleanValue()) {
            return !CurioCompat.isSlotAdder(access);
        }
        return true;
    }

    public RagnarokTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        ArrayList<EntitySlotAccess> list = new ArrayList<EntitySlotAccess>(CurioCompat.getItemAccess(target).stream().filter(RagnarokTrait::allowSeal).toList());
        int count = Math.min(level, list.size());
        int time = (Integer)LHConfig.SERVER.ragnarokTime.get() * level;
        for (int i = 0; i < count; ++i) {
            int index = attacker.getRandom().nextInt(list.size());
            EntitySlotAccess slot = (EntitySlotAccess)list.remove(index);
            slot.modify(e -> SealedItem.sealItem(e, time));
        }
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(access, i -> Component.literal((String)("" + i)).withStyle(ChatFormatting.AQUA)), this.mapLevel(access, i -> Component.literal((String)("" + Math.round((float)((Integer)LHConfig.SERVER.ragnarokTime.get() * i) / 20.0f))).withStyle(ChatFormatting.AQUA))}).withStyle(ChatFormatting.GRAY));
    }
}

