/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.legendary;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.curio.misc.Abrahadabra;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHDamageTypes;
import dev.xkmc.l2hostility.init.network.TraitEffectToClient;
import dev.xkmc.l2hostility.init.network.TraitEffects;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.network.SimplePacketBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class KillerAuraTrait
extends LegendaryTrait {
    public KillerAuraTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void tick(LivingEntity mob, int level) {
        int range;
        block5: {
            int itv = (Integer)LHConfig.SERVER.killerAuraInterval.get() / level;
            int damage = (Integer)LHConfig.SERVER.killerAuraDamage.get() * level;
            range = (Integer)LHConfig.SERVER.killerAuraRange.get();
            if (mob.level().isClientSide() || mob.tickCount % itv != 0) break block5;
            MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)mob);
            AABB box = mob.getBoundingBox().inflate((double)range);
            for (LivingEntity e : mob.level().getEntitiesOfClass(LivingEntity.class, box)) {
                block7: {
                    Mob mobmob;
                    Mob target;
                    block6: {
                        if (!(e instanceof Player)) break block6;
                        Player pl = (Player)e;
                        if (!pl.getAbilities().instabuild) break block7;
                    }
                    if ((!(e instanceof Mob) || (target = (Mob)e).getTarget() != mob) && (!(mob instanceof Mob) || (mobmob = (Mob)mob).getTarget() != e)) continue;
                }
                if (e.distanceTo((Entity)mob) > (float)range || mob.isAlliedTo((Entity)e) || ((Abrahadabra)((Object)LHItems.ABRAHADABRA.get())).isOn(e)) continue;
                TraitEffectCache cache = new TraitEffectCache(e);
                cap.traitEvent((k, v) -> k.postHurtPlayer((int)v, mob, cache));
                e.hurt(new DamageSource(LHDamageTypes.forKey(mob.level(), LHDamageTypes.KILLER_AURA), null, (Entity)mob), (float)damage);
            }
            L2Hostility.HANDLER.toTrackingPlayers((SimplePacketBase)TraitEffectToClient.of(mob, this, TraitEffects.AURA), (Entity)mob);
        }
        if (mob.level().isClientSide()) {
            Vec3 center = mob.position();
            float tpi = (float)Math.PI * 2;
            Vec3 v0 = new Vec3(0.0, (double)range, 0.0);
            v0 = v0.xRot(tpi / 4.0f).yRot(mob.getRandom().nextFloat() * tpi);
            mob.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(access, i -> Component.literal((String)("" + (Integer)LHConfig.SERVER.killerAuraDamage.get() * i)).withStyle(ChatFormatting.AQUA)), Component.literal((String)String.valueOf(LHConfig.SERVER.killerAuraRange.get())).withStyle(ChatFormatting.AQUA), this.mapLevel(access, i -> Component.literal((String)("" + (double)Math.round((double)((Integer)LHConfig.SERVER.killerAuraInterval.get()).intValue() * 5.0 / (double)i.intValue()) * 0.01)).withStyle(ChatFormatting.AQUA))}).withStyle(ChatFormatting.GRAY));
    }
}

