/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.legendary;

import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.init.data.L2DamageTypes;
import dev.xkmc.l2hostility.content.item.traits.EnchantmentDisabler;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;

public class DispellTrait
extends LegendaryTrait {
    public DispellTrait(ChatFormatting style) {
        super(style);
    }

    @Override
    public void onCreateSource(int level, LivingEntity attacker, CreateSourceEvent event) {
        if (event.getResult() == L2DamageTypes.MOB_ATTACK) {
            event.enable((DamageState)DefaultDamageState.BYPASS_MAGIC);
        }
    }

    @Override
    public double modifyBonusDamage(DamageSource source, double factor, int lv) {
        if (source.getMsgId().equals("mob") && source.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return (Double)LHConfig.SERVER.dispellDamageFactor.get();
        }
        return 1.0;
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = target.getItemBySlot(slot);
            if (!stack.isEnchanted() || LHItems.DC_DISPELL_ENCH.get(stack) != null) continue;
            list.add(stack);
        }
        if (list.isEmpty()) {
            return;
        }
        int time = (Integer)LHConfig.SERVER.dispellTime.get() * level;
        int count = Math.min(level, list.size());
        for (int i = 0; i < count; ++i) {
            int index = attacker.getRandom().nextInt(list.size());
            EnchantmentDisabler.disableEnchantment(attacker.level(), (ItemStack)list.remove(index), time);
        }
    }

    @Override
    public boolean onAttackedByOthers(int level, LivingEntity entity, DamageData.Attack event) {
        return !event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !event.getSource().is(DamageTypeTags.BYPASSES_EFFECTS) && event.getSource().is(Tags.DamageTypes.IS_MAGIC);
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(access, i -> Component.literal((String)("" + i)).withStyle(ChatFormatting.AQUA)), this.mapLevel(access, i -> Component.literal((String)("" + (Integer)LHConfig.SERVER.dispellTime.get() * i / 20)).withStyle(ChatFormatting.AQUA))}).withStyle(ChatFormatting.GRAY));
    }
}

