/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.highlevel;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.traits.EffectBooster;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class DrainTrait
extends MobTrait {
    public DrainTrait(ChatFormatting format) {
        super(format);
    }

    @Override
    public void postInit(LivingEntity mob, int lv) {
        MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)mob);
        Optional potions = LHTraits.TRAITS.reg().getTag(LHTraits.POTION);
        if (potions.isEmpty() || ((HolderSet.Named)potions.get()).size() == 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            MobTrait trait;
            Optional opt = ((HolderSet.Named)potions.get()).getRandomElement(mob.getRandom());
            if (opt.isEmpty() || !(trait = (MobTrait)((Object)((Holder)opt.get()).value())).allow(mob) || cap.hasTrait(trait)) continue;
            cap.setTrait(trait, lv);
            return;
        }
    }

    @Override
    public void onHurtTarget(int level, LivingEntity attacker, DamageData.Offence cache, TraitEffectCache traitCache) {
        LivingEntity target = cache.getTarget();
        long neg = target.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL).count();
        cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (Double)LHConfig.SERVER.drainDamage.get() * (double)level * (double)neg)), (ResourceLocation)this.getRegistryName()));
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        ArrayList<MobEffectInstance> pos = new ArrayList<MobEffectInstance>(target.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL).toList());
        for (int i = 0; i < level; ++i) {
            if (pos.isEmpty()) continue;
            MobEffectInstance ins = pos.remove(attacker.getRandom().nextInt(pos.size()));
            target.removeEffect(ins.getEffect());
        }
        double factor = 1.0 + (Double)LHConfig.SERVER.drainDuration.get() * (double)level;
        int maxTime = level * (Integer)LHConfig.SERVER.drainDurationMax.get();
        EffectBooster.boostTrait(target, factor, maxTime);
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{this.mapLevel(access, i -> Component.literal((String)("" + i)).withStyle(ChatFormatting.AQUA)), this.mapLevel(access, i -> Component.literal((String)(Math.round((double)i.intValue() * (Double)LHConfig.SERVER.drainDamage.get() * 100.0) + "%")).withStyle(ChatFormatting.AQUA)), this.mapLevel(access, i -> Component.literal((String)(Math.round((double)i.intValue() * (Double)LHConfig.SERVER.drainDuration.get() * 100.0) + "%")).withStyle(ChatFormatting.AQUA)), this.mapLevel(access, i -> Component.literal((String)("" + Math.round((float)(i * (Integer)LHConfig.SERVER.drainDurationMax.get()) / 20.0f))).withStyle(ChatFormatting.AQUA))}).withStyle(ChatFormatting.GRAY));
    }
}

