/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.highlevel;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.traits.common.AuraEffectTrait;
import dev.xkmc.l2hostility.init.registrate.LHEffects;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class ArenaTrait
extends AuraEffectTrait {
    public ArenaTrait() {
        super((Holder<MobEffect>)LHEffects.ANTIBUILD);
    }

    @Override
    protected boolean canApply(LivingEntity e) {
        return true;
    }

    @Override
    public boolean onAttackedByOthers(int level, LivingEntity entity, DamageData.Attack event) {
        if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity2;
            if (attacker.hasEffect(LHEffects.ANTIBUILD)) {
                return false;
            }
            if (attacker instanceof Mob) {
                Mob mob = (Mob)attacker;
                if (((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)mob).map(e -> e.getTraitLevel(this)).orElse(0) >= level) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onDamaged(int level, LivingEntity mob, DamageData.Defence cache) {
        if (cache.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        if (cache.getAttacker() != null && cache.getAttacker().hasEffect(LHEffects.ANTIBUILD)) {
            return;
        }
        cache.addDealtModifier(DamageModifier.nonlinearFinal((int)12345, e -> 0.0f, (ResourceLocation)this.getRegistryName()));
    }
}

