/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.common;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2hostility.content.capability.mob.CapStorageData;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.entity.BulletType;
import dev.xkmc.l2hostility.content.entity.HostilityBullet;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class ShulkerTrait
extends MobTrait {
    private final IntSupplier interval;
    private final BulletType type;
    private final int offset;

    public ShulkerTrait(ChatFormatting format, IntSupplier interval, BulletType type, int offset) {
        super(format);
        this.interval = interval;
        this.type = type;
        this.offset = offset;
    }

    @Override
    public boolean onAttackedByOthers(int level, LivingEntity entity, DamageData.Attack event) {
        return this.type.onAttackedByOthers(level, entity, event);
    }

    @Override
    public double modifyBonusDamage(DamageSource source, double factor, int lv) {
        if (source.getDirectEntity() instanceof HostilityBullet && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return (Double)LHConfig.SERVER.grenadeDamageFactor.get();
        }
        return 1.0;
    }

    @Override
    public void tick(LivingEntity e, int level) {
        ServerLevel sl;
        Level level2;
        if (e.level().isClientSide()) {
            return;
        }
        if (!(e instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)e;
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)e);
        if (opt.isEmpty()) {
            return;
        }
        Data data = ((MobTraitCap)((Object)opt.get())).getOrCreateData(this.getRegistryName(), Data::new);
        if (data.uuid != null && (level2 = mob.level()) instanceof ServerLevel && (sl = (ServerLevel)level2).getEntity(data.uuid) instanceof ShulkerBullet) {
            return;
        }
        ++data.tickCount;
        if (data.tickCount < this.interval.getAsInt()) {
            return;
        }
        if ((mob.tickCount + this.offset) % this.interval.getAsInt() != 0) {
            return;
        }
        if (mob.getTarget() != null && mob.getTarget().isAlive()) {
            HostilityBullet bullet = new HostilityBullet(mob.level(), (LivingEntity)mob, (Entity)mob.getTarget(), Direction.Axis.Y, this.type, level);
            data.tickCount = 0;
            if (this.type.limit()) {
                data.uuid = bullet.getUUID();
            }
            mob.level().addFreshEntity((Entity)bullet);
            mob.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (mob.getRandom().nextFloat() - mob.getRandom().nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{Component.literal((String)("" + (double)this.interval.getAsInt() / 20.0)).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
    }

    @SerialClass
    public static class Data
    extends CapStorageData {
        @SerialField
        public int tickCount;
        @SerialField
        public UUID uuid;
    }
}

