/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.common;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2hostility.content.logic.TraitEffectCache;
import dev.xkmc.l2hostility.content.traits.base.SelfEffectTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FieryTrait
extends SelfEffectTrait {
    public FieryTrait() {
        super((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE);
    }

    @Override
    public void onHurtTargetMax(int level, LivingEntity attacker, DamageData.OffenceMax cache, TraitEffectCache traitCache) {
        Entity entity;
        if (cache.getDamageOriginal() > 0.0f && (entity = cache.getSource().getDirectEntity()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.setRemainingFireTicks((Integer)LHConfig.SERVER.fieryTime.get() * 20);
        }
    }

    @Override
    public boolean onAttackedByOthers(int level, LivingEntity entity, DamageData.Attack event) {
        Entity entity2 = event.getSource().getDirectEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity2;
            le.setRemainingFireTicks((Integer)LHConfig.SERVER.fieryTime.get() * 20);
        }
        return event.getSource().is(DamageTypeTags.IS_FIRE);
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{Component.literal((String)String.valueOf(LHConfig.SERVER.fieryTime.get())).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
        super.addDetail(access, list);
    }
}

