/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.common;

import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2hostility.content.capability.mob.PerformanceConstants;
import dev.xkmc.l2hostility.content.item.curio.misc.Abrahadabra;
import dev.xkmc.l2hostility.content.item.curio.ring.RingOfReflection;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AuraEffectTrait
extends MobTrait {
    private final Holder<MobEffect> eff;

    public AuraEffectTrait(Holder<MobEffect> eff) {
        super(() -> ((MobEffect)eff.value()).getColor());
        this.eff = eff;
    }

    protected boolean canApply(LivingEntity e) {
        if (((RingOfReflection)((Object)LHItems.RING_REFLECTION.get())).isOn(e)) {
            return false;
        }
        return !((Abrahadabra)((Object)LHItems.ABRAHADABRA.get())).isOn(e);
    }

    @Override
    public void tick(LivingEntity mob, int level) {
        int range = (Integer)LHConfig.SERVER.range.get(this.getRegistryName().getPath()).get();
        if (!mob.level().isClientSide() && mob.tickCount % PerformanceConstants.auraApplyInterval() == 0) {
            AABB box = mob.getBoundingBox().inflate((double)range);
            for (LivingEntity e : mob.level().getEntitiesOfClass(LivingEntity.class, box)) {
                if (e instanceof Player) {
                    Player pl = (Player)e;
                    if (pl.getAbilities().instabuild) continue;
                }
                if (e.distanceTo((Entity)mob) > (float)range || !this.canApply(e)) continue;
                EffectUtil.refreshEffect((LivingEntity)e, (MobEffectInstance)new MobEffectInstance(this.eff, 40, level - 1, true, true), (Entity)mob);
            }
        }
        if (mob.level().isClientSide()) {
            Vec3 center = mob.position();
            float tpi = (float)Math.PI * 2;
            Vec3 v0 = new Vec3(0.0, (double)range, 0.0);
            v0 = v0.xRot(tpi / 4.0f).yRot(mob.getRandom().nextFloat() * tpi);
            int k = ((MobEffect)this.eff.value()).getColor();
            mob.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.EFFECT, center.x + v0.x, center.y + v0.y + 0.5, center.z + v0.z, (double)(k >> 16 & 0xFF) / 255.0, (double)(k >> 8 & 0xFF) / 255.0, (double)(k & 0xFF) / 255.0);
        }
    }
}

