/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.base;

import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2hostility.content.item.curio.ring.RingOfReflection;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class TargetEffectTrait
extends MobTrait {
    public final Function<Integer, MobEffectInstance> func;

    public TargetEffectTrait(Function<Integer, MobEffectInstance> func) {
        super(() -> ((MobEffect)((MobEffectInstance)func.apply(1)).getEffect().value()).getColor());
        this.func = func;
    }

    public TargetEffectTrait(IntSupplier color, Function<Integer, MobEffectInstance> func) {
        super(color);
        this.func = func;
    }

    @Override
    public void postHurtImpl(int level, LivingEntity attacker, LivingEntity target) {
        if (((RingOfReflection)((Object)LHItems.RING_REFLECTION.get())).isOn(target)) {
            int radius = (Integer)LHConfig.SERVER.ringOfReflectionRadius.get();
            for (Entity e : target.level().getEntities((Entity)target, target.getBoundingBox().inflate((double)radius))) {
                Mob mob;
                if (!(e instanceof Mob) || (mob = (Mob)e).distanceTo((Entity)target) > (float)radius) continue;
                EffectUtil.addEffect((LivingEntity)mob, (MobEffectInstance)this.func.apply(level), (Entity)attacker);
            }
        } else {
            EffectUtil.addEffect((LivingEntity)target, (MobEffectInstance)this.func.apply(level), (Entity)attacker);
        }
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)LangData.TOOLTIP_TARGET_EFFECT.get(new Object[0]));
        list.add((Component)this.mapLevel(access, e -> {
            MobEffectInstance ins = this.func.apply((Integer)e);
            MutableComponent ans = Component.translatable((String)ins.getDescriptionId());
            MobEffect mobeffect = (MobEffect)ins.getEffect().value();
            if (ins.getAmplifier() > 0) {
                ans = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{ans, Component.translatable((String)("potion.potency." + ins.getAmplifier()))});
            }
            if (!ins.endsWithin(20)) {
                ans = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{ans, MobEffectUtil.formatDuration((MobEffectInstance)ins, (float)1.0f, (float)20.0f)});
            }
            return ans.withStyle(mobeffect.getCategory().getTooltipFormatting());
        }));
    }
}

