/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.base;

import dev.xkmc.l2core.base.effects.EffectUtil;
import dev.xkmc.l2hostility.content.capability.mob.PerformanceConstants;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SelfEffectTrait
extends MobTrait {
    public final Holder<MobEffect> effect;

    public SelfEffectTrait(Holder<MobEffect> effect) {
        super(() -> ((MobEffect)effect.value()).getColor());
        this.effect = effect;
    }

    @Override
    public void tick(LivingEntity mob, int level) {
        if (mob.level().isClientSide()) {
            return;
        }
        EffectUtil.refreshEffect((LivingEntity)mob, (MobEffectInstance)new MobEffectInstance(this.effect, PerformanceConstants.selfEffectInterval(), level - 1), (Entity)mob);
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        list.add((Component)LangData.TOOLTIP_SELF_EFFECT.get(new Object[0]));
        ChatFormatting color = ((MobEffect)this.effect.value()).getCategory().getTooltipFormatting();
        if (this.getMaxLevel(access) == 1) {
            list.add((Component)((MobEffect)this.effect.value()).getDisplayName().copy().withStyle(color));
        } else {
            list.add((Component)this.mapLevel(access, e -> Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{((MobEffect)this.effect.value()).getDisplayName(), Component.translatable((String)("potion.potency." + (e - 1)))}).withStyle(color)));
        }
    }
}

