/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.traits.base;

import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.TooltipFlag;

public class AttributeTrait
extends MobTrait {
    private final AttributeEntry[] entries;

    public AttributeTrait(ChatFormatting style, AttributeEntry ... entries) {
        super(style);
        this.entries = entries;
    }

    public AttributeTrait(IntSupplier color, AttributeEntry ... entries) {
        super(color);
        this.entries = entries;
    }

    @Override
    public void initialize(LivingEntity le, int level) {
        for (AttributeEntry e : this.entries) {
            TraitManager.addAttribute(le, e.attribute, e.name(), e.factor.getAsDouble() * (double)level, e.op());
        }
    }

    @Override
    public void addDetail(RegistryAccess access, List<Component> list) {
        for (AttributeEntry e : this.entries) {
            double val = e.factor.getAsDouble();
            if (val == 0.0) continue;
            list.add((Component)this.mapLevel(access, i -> ((Attribute)e.attribute().value()).toValueComponent(e.op, val * (double)i.intValue(), (TooltipFlag)TooltipFlag.NORMAL).withStyle(ChatFormatting.AQUA)).append(CommonComponents.SPACE).append((Component)Component.translatable((String)((Attribute)e.attribute.value()).getDescriptionId()).withStyle(ChatFormatting.BLUE)));
        }
    }

    public record AttributeEntry(String name, Holder<Attribute> attribute, DoubleSupplier factor, AttributeModifier.Operation op) {
    }
}

