/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.menu.tab;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2tabs.init.L2Tabs;
import dev.xkmc.l2tabs.tabs.contents.BaseTextScreen;
import dev.xkmc.l2tabs.tabs.core.ITabScreen;
import dev.xkmc.l2tabs.tabs.core.TabGroupData;
import dev.xkmc.l2tabs.tabs.core.TabManager;
import dev.xkmc.l2tabs.tabs.core.TabToken;
import dev.xkmc.l2tabs.tabs.inventory.InvTabData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class DifficultyScreen
extends BaseTextScreen {
    protected DifficultyScreen(Component title) {
        super(title, L2Tabs.loc((String)"textures/gui/empty.png"));
    }

    public void init() {
        super.init();
        new TabManager((ITabScreen)this, (TabGroupData)new InvTabData()).init(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, (TabToken)LHMiscs.TAB_DIFFICULTY.get());
    }

    public void render(GuiGraphics g, int mx, int my, float ptick) {
        super.render(g, mx, my, ptick);
        int x = this.leftPos + 8;
        int y = this.topPos + 6;
        ArrayList<Pair<Component, Supplier<List<Component>>>> list = new ArrayList<Pair<Component, Supplier<List<Component>>>>();
        DifficultyScreen.addDifficultyInfo(list, ChatFormatting.DARK_RED, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_PURPLE);
        DifficultyScreen.addRewardInfo(list);
        List tooltip = null;
        for (Pair pair : list) {
            if (mx >= x && mx <= x + this.font.width((FormattedText)pair.getFirst()) && my >= y && my <= y + 10) {
                tooltip = pair.getSecond() == null ? null : (List)((Supplier)pair.getSecond()).get();
            }
            g.drawString(this.font, (Component)pair.getFirst(), x, y, 0, false);
            y += 10;
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            g.renderComponentTooltip(this.font, tooltip, mx, my);
        }
    }

    public static void addRewardInfo(List<Pair<Component, Supplier<List<Component>>>> list) {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        PlayerDifficulty cap = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
        list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_REWARD.get(cap.getRewardCount()).withStyle(ChatFormatting.DARK_GREEN), List::of));
    }

    public static void addDifficultyInfo(List<Pair<Component, Supplier<List<Component>>>> list, ChatFormatting ... formats) {
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        PlayerDifficulty cap = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
        list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_PLAYER_LEVEL.get(cap.getLevel((Player)player).getStr()), () -> DifficultyScreen.lambda$addDifficultyInfo$1(cap, (Player)player)));
        int perc = Math.round(100.0f * (float)cap.getLevel((Player)player).getExp() / (float)cap.getLevel((Player)player).getMaxExp());
        list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_PLAYER_EXP.get(perc), List::of));
        int maxCap = cap.getRankCap();
        list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_PLAYER_CAP.get(maxCap > TraitManager.getMaxLevel() ? LangData.TOOLTIP_LEGENDARY.get(new Object[0]).withStyle(formats[2]) : Integer.valueOf(maxCap)), List::of));
        Optional<ChunkCapHolder> opt = ChunkDifficulty.at(player.level(), player.blockPosition());
        if (opt.isPresent()) {
            ChunkCapHolder chunk = opt.get();
            SectionDifficulty sec = chunk.getSection(player.blockPosition().getY());
            if (sec.isCleared()) {
                list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_CHUNK_CLEAR.get(new Object[0]).withStyle(formats[1]), List::of));
            } else {
                MobDifficultyCollector ins = new MobDifficultyCollector();
                chunk.modifyInstance(player.blockPosition(), ins);
                list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_CHUNK_LEVEL.get(ins.getBase()).withStyle(formats[0]), () -> DifficultyScreen.lambda$addDifficultyInfo$2(sec, (Player)player)));
                list.add((Pair<Component, Supplier<List<Component>>>)Pair.of((Object)LangData.INFO_CHUNK_SCALE.get(ins.scale).withStyle(formats[0]), List::of));
            }
        }
    }

    private static /* synthetic */ List lambda$addDifficultyInfo$2(SectionDifficulty sec, Player player) {
        return sec.getSectionDifficultyDetail(player);
    }

    private static /* synthetic */ List lambda$addDifficultyInfo$1(PlayerDifficulty cap, Player player) {
        return cap.getPlayerDifficultyDetail(player);
    }
}

