/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.config.TraitExclusion;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

public class TraitGenerator {
    private final LivingEntity entity;
    private final int mobLevel;
    private final int maxTrait;
    private final MobDifficultyCollector ins;
    private final HashMap<MobTrait, Integer> traits;
    private final RandomSource rand;
    private final RegistryAccess access;
    private final TraitPool pool;
    private final boolean free;
    private int level;

    public static void generateTraits(MobTraitCap cap, LivingEntity le, int lv, HashMap<MobTrait, Integer> traits, MobDifficultyCollector ins) {
        new TraitGenerator(cap, le, lv, traits, ins).generate();
    }

    private TraitGenerator(MobTraitCap cap, LivingEntity entity, int mobLevel, HashMap<MobTrait, Integer> traits, MobDifficultyCollector ins) {
        this.entity = entity;
        this.mobLevel = mobLevel;
        this.ins = ins;
        this.traits = traits;
        this.access = entity.level().registryAccess();
        this.rand = entity.getRandom();
        this.level = mobLevel;
        this.free = ins.trait_cost < 0.01;
        EntityConfig.Config config = cap.getConfigCache(entity);
        int max = (Integer)LHConfig.SERVER.maxTraitCount.get();
        if (config != null && config.maxTraitCount > 0) {
            max = config.maxTraitCount;
        }
        int n = this.maxTrait = this.free ? -1 : (int)((double)max / ins.trait_cost);
        if (config != null) {
            for (EntityConfig.TraitBase base : config.traits()) {
                if (base.condition() != null && !base.condition().match(entity, mobLevel, ins)) continue;
                this.genBase(base);
            }
        }
        List<MobTrait> list = LHTraits.TRAITS.get().stream().filter(e -> (config == null || !config.blacklist().contains(e)) && e.allow(entity, mobLevel, ins.getMaxTraitLevel())).toList();
        this.pool = new TraitPool(list, traits);
    }

    private int getRank(MobTrait e) {
        return this.traits.getOrDefault((Object)e, 0);
    }

    private void setRank(MobTrait e, int rank) {
        if (rank == 0) {
            this.traits.remove((Object)e);
        } else {
            if (this.pool != null && this.getRank(e) == 0) {
                this.pool.update(e);
            }
            this.traits.put(e, rank);
        }
    }

    private void genBase(EntityConfig.TraitBase base) {
        MobTrait e = base.trait();
        if (e == null) {
            return;
        }
        int maxTrait = TraitManager.getMaxLevel() + 1;
        if (!e.allow(this.entity, this.mobLevel, maxTrait)) {
            return;
        }
        int max = e.getMaxLevel(this.access);
        int cost = e.getCost(this.access, this.ins.trait_cost);
        int old = Math.min(e.getMaxLevel(this.access), Math.max(this.getRank(e), base.free()));
        int expected = Math.min(max, Math.max(old, base.min()));
        int rank = Math.min(expected, old + this.level / cost);
        this.setRank(e, Math.max(old, rank));
        if (rank > old) {
            this.level -= (rank - old) * cost;
        }
    }

    private void generate() {
        while (!(this.level <= 0 || this.pool.isEmpty() || this.maxTrait > 0 && this.traits.size() >= this.maxTrait)) {
            int rank;
            MobTrait e = this.pool.pop();
            int cost = e.getCost(this.access, this.ins.trait_cost);
            if (cost > this.level) continue;
            int max = Math.min(this.ins.getMaxTraitLevel(), e.getMaxLevel(this.access));
            int old = Math.min(e.getMaxLevel(this.access), this.getRank(e));
            int n = rank = this.free ? max : Math.min(max, old + this.rand.nextInt(this.level / cost) + 1);
            if (rank <= old) continue;
            this.setRank(e, rank);
            this.level -= (rank - old) * cost;
            if (this.ins.isFullChance() || !(this.rand.nextDouble() < this.ins.suppression())) continue;
            break;
        }
        for (Map.Entry<MobTrait, Integer> e : this.traits.entrySet()) {
            e.getKey().initialize(this.entity, e.getValue());
        }
    }

    private class TraitPool {
        private final LinkedList<TraitEntry> list = new LinkedList();
        private final LinkedHashMap<MobTrait, TraitEntry> map = new LinkedHashMap();
        private final Set<MobTrait> existing = new LinkedHashSet<MobTrait>();
        private int weights = 0;

        public TraitPool(List<MobTrait> available, HashMap<MobTrait, Integer> existing) {
            for (MobTrait trait : available) {
                TraitEntry ent = new TraitEntry(TraitGenerator.this, trait);
                this.list.add(ent);
                this.map.put(trait, ent);
            }
            for (TraitEntry e : this.list) {
                this.weights += e.weight();
            }
            for (MobTrait trait : existing.keySet()) {
                this.update(trait);
            }
            this.purge();
        }

        private MobTrait pop() {
            int val = TraitGenerator.this.rand.nextInt(this.weights);
            TraitEntry e = this.list.getFirst();
            Iterator itr = this.list.iterator();
            while (itr.hasNext()) {
                TraitEntry x = (TraitEntry)itr.next();
                if ((val -= x.weight()) > 0) continue;
                e = x;
                itr.remove();
                this.map.remove((Object)e.trait);
                this.weights -= e.weight();
                return e.trait;
            }
            this.list.remove(e);
            this.map.remove((Object)e.trait);
            this.weights -= e.weight();
            return e.trait;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void update(MobTrait trait) {
            if (this.existing.contains((Object)trait)) {
                return;
            }
            this.existing.add(trait);
            TraitExclusion data = trait.getExclusion(TraitGenerator.this.access);
            for (Map.Entry<Holder<MobTrait>, Double> pair : data.excluded().entrySet()) {
                TraitEntry entry = this.map.get(pair.getKey().value());
                if (entry == null) continue;
                this.weights -= entry.updateExclusion(pair.getValue());
            }
            for (TraitEntry e : this.list) {
                TraitExclusion exc = e.trait.getExclusion(TraitGenerator.this.access);
                Double val = exc.excluded().getOrDefault(trait.holder(), 0.0);
                if (val == 0.0) continue;
                this.weights -= e.updateExclusion(val);
            }
            this.purge();
        }

        private void purge() {
            Iterator itr = this.list.iterator();
            while (itr.hasNext()) {
                TraitEntry x = (TraitEntry)itr.next();
                if (x.weight() != 0) continue;
                itr.remove();
                this.map.remove((Object)x.trait);
            }
        }
    }

    private class TraitEntry {
        private final MobTrait trait;
        private final int baseWeight;
        private double chance;
        private int weight;

        private TraitEntry(TraitGenerator traitGenerator, MobTrait trait) {
            this.trait = trait;
            this.chance = 1.0;
            this.weight = this.baseWeight = trait.getConfig(traitGenerator.access).weight();
        }

        public int weight() {
            return this.weight;
        }

        public int updateExclusion(double value) {
            int old = this.weight;
            this.chance *= 1.0 - value;
            this.weight = (int)((double)this.baseWeight * this.chance);
            return old - this.weight;
        }
    }
}

