/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.config.WeaponConfig;
import dev.xkmc.l2hostility.content.logic.PlayerFinder;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.mob_weapon_api.example.vanilla.VanillaMobManager;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class ItemPopulator {
    static void populateArmors(LivingEntity le, int lv) {
        ServerPlayer player;
        if (ItemPopulator.isApothBoss(le)) {
            return;
        }
        RandomSource r = le.getRandom();
        Player player2 = PlayerFinder.getNearestPlayer(le.level(), le);
        ServerPlayer sp = player2 instanceof ServerPlayer ? (player = (ServerPlayer)player2) : null;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || !le.getItemBySlot(slot).isEmpty() || (stack = WeaponConfig.getRandomArmor(slot, lv, r, sp)).isEmpty()) continue;
            le.setItemSlot(slot, stack);
            if (!(le instanceof Mob)) continue;
            Mob mob = (Mob)le;
            mob.setDropChance(slot, ((Double)LHConfig.SERVER.equipmentDropRate.get()).floatValue());
        }
    }

    static void populateWeapons(LivingEntity le, MobTraitCap cap, RandomSource r, @Nullable ServerPlayer sp) {
        PathfinderMob e;
        ItemStack stack;
        Mob mob;
        ItemStack stack2;
        double factor;
        if (ItemPopulator.isApothBoss(le) || ItemPopulator.isApothWeapon(le.getMainHandItem())) {
            return;
        }
        if (le instanceof Drowned && le.getMainHandItem().isEmpty() && (factor = (double)cap.getLevel() * (Double)LHConfig.SERVER.drownedTridentChancePerLevel.get()) > le.getRandom().nextDouble()) {
            le.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.TRIDENT));
        }
        if (le.getType().is(LHTagGen.MELEE_WEAPON_TARGET) && le.getMainHandItem().isEmpty() && !(stack2 = WeaponConfig.getRandomMeleeWeapon(cap.getLevel(), r, sp)).isEmpty()) {
            le.setItemSlot(EquipmentSlot.MAINHAND, stack2);
            if (le instanceof Mob) {
                mob = (Mob)le;
                mob.setDropChance(EquipmentSlot.MAINHAND, ((Double)LHConfig.SERVER.equipmentDropRate.get()).floatValue());
            }
        }
        if (le.getType().is(LHTagGen.RANGED_WEAPON_TARGET) && !(stack = WeaponConfig.getRandomRangedWeapon(cap.getLevel(), r, sp)).isEmpty()) {
            le.setItemSlot(EquipmentSlot.MAINHAND, stack);
            if (le instanceof Mob) {
                mob = (Mob)le;
                mob.setDropChance(EquipmentSlot.MAINHAND, ((Double)LHConfig.SERVER.equipmentDropRate.get()).floatValue());
            }
        }
        ArrayList<WeaponConfig.ItemConfig> list = new ArrayList<WeaponConfig.ItemConfig>();
        for (Map.Entry<HolderSet<EntityType<?>>, ArrayList<WeaponConfig.ItemConfig>> ent : ((WeaponConfig)L2Hostility.WEAPON.getMerged()).special_weapons.entrySet()) {
            if (!le.getType().is(ent.getKey())) continue;
            for (WeaponConfig.ItemConfig e2 : ent.getValue()) {
                boolean nonEmpty = false;
                for (ItemStack stack3 : e2.stack()) {
                    nonEmpty |= !stack3.isEmpty();
                }
                if (!nonEmpty) continue;
                list.add(e2);
            }
        }
        if (list.isEmpty()) {
            return;
        }
        list.add(WeaponConfig.ItemConfig.EMPTY);
        ItemStack stack4 = WeaponConfig.getRandomWeapon(list, cap.getLevel(), le.getRandom(), sp);
        if (stack4.isEmpty()) {
            return;
        }
        le.setItemSlot(EquipmentSlot.MAINHAND, stack4);
        if (le instanceof PathfinderMob && VanillaMobManager.attachGoal((PathfinderMob)(e = (PathfinderMob)le), (ItemStack)stack4)) {
            e.addTag("mob_weapon_api_applied");
        }
        if (le instanceof Mob) {
            Mob mob2 = (Mob)le;
            mob2.setDropChance(EquipmentSlot.MAINHAND, ((Double)LHConfig.SERVER.equipmentDropRate.get()).floatValue());
        }
    }

    static void generateItems(MobTraitCap cap, LivingEntity le, EntityConfig.ItemPool pool) {
        if (cap.getLevel() < pool.level()) {
            return;
        }
        if (le.getRandom().nextFloat() > pool.chance()) {
            return;
        }
        EntitySlotAccess slot = CurioCompat.decode(pool.slot(), le);
        if (slot == null) {
            return;
        }
        ArrayList<EntityConfig.ItemEntry> list = pool.entries();
        int total = 0;
        for (EntityConfig.ItemEntry e : list) {
            total += e.weight();
        }
        if (total <= 0) {
            return;
        }
        total = le.getRandom().nextInt(total);
        for (EntityConfig.ItemEntry e : list) {
            if ((total -= e.weight()) > 0) continue;
            slot.set(e.stack().copy());
            return;
        }
    }

    public static void fillEnch(RegistryAccess access, int level, RandomSource source, ItemStack stack, EquipmentSlot slot) {
        if (ItemPopulator.isApothWeapon(stack)) {
            return;
        }
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        if (slot == EquipmentSlot.OFFHAND) {
            return;
        }
        ArrayList<WeaponConfig.EnchConfig> list = slot == EquipmentSlot.MAINHAND ? config.weapon_enchantments : config.armor_enchantments;
        ItemEnchantments.Mutable map = new ItemEnchantments.Mutable(stack.getAllEnchantments(access.lookupOrThrow(Registries.ENCHANTMENT)));
        for (WeaponConfig.EnchConfig e : list) {
            int elv;
            int n = elv = e.level() <= 0 ? 1 : e.level();
            if (elv > level) continue;
            for (ResourceLocation key : e.enchantments()) {
                Holder holder;
                if ((double)e.chance() < source.nextDouble() || !stack.isPrimaryItemFor(holder = access.holderOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)key))) || !ItemPopulator.isValid(map.keySet(), (Holder<Enchantment>)holder)) continue;
                int max = Math.min(level / elv, ((Enchantment)holder.value()).getMaxLevel());
                map.set(holder, Math.max(max, map.getLevel(holder)));
            }
        }
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)map.toImmutable());
    }

    private static boolean isValid(Set<Holder<Enchantment>> old, Holder<Enchantment> ench) {
        for (Holder<Enchantment> other : old) {
            if (!ench.equals(other)) continue;
            return true;
        }
        for (Holder<Enchantment> other : old) {
            if (Enchantment.areCompatible(ench, other)) continue;
            return false;
        }
        return true;
    }

    public static void postFill(MobTraitCap cap, LivingEntity le) {
        ServerPlayer player;
        EquipmentSlot[] equipmentSlotArray = PlayerFinder.getNearestPlayer(le.level(), le);
        ServerPlayer sp = equipmentSlotArray instanceof ServerPlayer ? (player = (ServerPlayer)equipmentSlotArray) : null;
        RandomSource r = le.getRandom();
        ItemPopulator.populateWeapons(le, cap, r, sp);
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = le.getItemBySlot(e);
            if (!stack.isEnchantable()) continue;
            if (((Boolean)LHConfig.SERVER.allowExtraEnchantments.get()).booleanValue()) {
                ItemPopulator.fillEnch(le.level().registryAccess(), cap.getLevel(), le.getRandom(), stack, e);
            }
            le.setItemSlot(e, stack);
        }
        EntityConfig.Config config = cap.getConfigCache(le);
        if (config != null && !config.items.isEmpty()) {
            for (EntityConfig.ItemPool pool : config.items) {
                ItemPopulator.generateItems(cap, le, pool);
            }
        }
    }

    private static boolean isApothBoss(LivingEntity mob) {
        if (!ModList.get().isLoaded("apotheosis")) {
            return false;
        }
        return mob.getPersistentData().getBoolean("apoth.boss");
    }

    private static boolean isApothWeapon(ItemStack stack) {
        if (!ModList.get().isLoaded("apotheosis")) {
            return false;
        }
        return (Boolean)stack.getOrDefault(Apoth.Components.FROM_BOSS, (Object)false);
    }
}

