/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.logic;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

@SerialClass
public class DifficultyLevel {
    @SerialField
    public int level;
    protected long experience;
    @SerialField
    public int extraLevel;

    public static DifficultyLevel merge(DifficultyLevel difficulty, int extraLevel) {
        DifficultyLevel ans = new DifficultyLevel();
        ans.level = difficulty.level;
        ans.experience = difficulty.experience;
        ans.extraLevel = difficulty.extraLevel + extraLevel;
        return ans;
    }

    public static int ofAny(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return ((PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player)).getLevel(player).getLevel();
        }
        return ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)entity).map(MobTraitCap::getLevel).orElse(0);
    }

    public void grow(double growFactor, MobTraitCap cap) {
        if (this.level >= (Integer)LHConfig.SERVER.maxPlayerLevel.get()) {
            this.level = (Integer)LHConfig.SERVER.maxPlayerLevel.get();
            this.experience = 0L;
            return;
        }
        this.experience += (long)((int)(growFactor * (double)cap.getLevel() * (double)cap.getLevel()));
        int factor = (Integer)LHConfig.SERVER.killsPerLevel.get();
        while (this.experience >= (long)this.level * (long)this.level * (long)factor) {
            this.experience -= (long)this.level * (long)this.level * (long)factor;
            ++this.level;
        }
        if (this.level >= (Integer)LHConfig.SERVER.maxPlayerLevel.get()) {
            this.level = (Integer)LHConfig.SERVER.maxPlayerLevel.get();
            this.experience = 0L;
        }
    }

    public void decay() {
        double rate = (Double)LHConfig.SERVER.playerDeathDecay.get();
        if (rate < 1.0) {
            this.level = Math.max(0, this.level - Math.max(1, (int)Math.ceil((double)this.level * (1.0 - rate))));
        }
        this.experience = 0L;
    }

    public long getMaxExp() {
        int factor = (Integer)LHConfig.SERVER.killsPerLevel.get();
        return Math.max(1L, (long)this.level * (long)this.level * (long)factor);
    }

    public int getLevel() {
        return Math.max(0, this.level + this.extraLevel);
    }

    public long getExp() {
        return this.experience;
    }

    public String getStr() {
        return this.extraLevel == 0 ? "" + this.level : (this.extraLevel > 0 ? this.level + "+" + this.extraLevel : "" + this.level + this.extraLevel);
    }
}

