/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.TraitConfig;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.content.traits.legendary.LegendaryTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class TraitSymbol
extends Item {
    private static boolean allow(Player player, MobTrait trait, LivingEntity target) {
        OwnableEntity own;
        if (!((Boolean)LHConfig.SERVER.allowPlayerAllies.get()).booleanValue() && target.isAlliedTo((Entity)player)) {
            return false;
        }
        if (!((Boolean)LHConfig.SERVER.allowTraitOnOwnable.get()).booleanValue() && target instanceof OwnableEntity && (own = (OwnableEntity)target).getOwner() instanceof Player) {
            return false;
        }
        return trait.allow(target);
    }

    public TraitSymbol(Item.Properties properties) {
        super(properties);
    }

    public MobTrait get() {
        return (MobTrait)((Object)LHTraits.TRAITS.get().get(BuiltInRegistries.ITEM.getKey((Object)this)));
    }

    protected String getOrCreateDescriptionId() {
        return Util.makeDescriptionId((String)LHTraits.TRAITS.key().location().getPath(), (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)target);
        if (opt.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)target) && !player.getAbilities().instabuild) {
            return InteractionResult.FAIL;
        }
        MobTraitCap cap = (MobTraitCap)((Object)opt.get());
        MobTrait trait = this.get();
        if (!TraitSymbol.allow(player, trait, target)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.sendSystemMessage((Component)LangData.MSG_ERR_DISALLOW.get(new Object[0]).withStyle(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (cap.getTraitLevel(trait) >= trait.getMaxLevel(player.registryAccess())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.sendSystemMessage((Component)LangData.MSG_ERR_MAX.get(new Object[0]).withStyle(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (player.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        int val = cap.traits.compute(trait, (k, v) -> (v == null ? 0 : v) + 1);
        trait.initialize(target, val);
        trait.postInit(target, val);
        cap.syncToClient(target);
        target.setHealth(target.getMaxHealth());
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.sendSystemMessage((Component)LangData.MSG_SET_TRAIT.get(trait.getDesc(), target.getDisplayName(), val), true);
            CriteriaTriggers.CONSUME_ITEM.trigger(sp, stack);
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        Level level;
        list.add((Component)this.get().getFullDesc(null));
        if (this.get().isBanned()) {
            list.add((Component)LangData.TOOLTIP_BANNED.get(new Object[0]).withStyle(ChatFormatting.RED));
            return;
        }
        if (this.get() instanceof LegendaryTrait) {
            list.add((Component)LangData.TOOLTIP_LEGENDARY.get(new Object[0]).withStyle(ChatFormatting.GOLD));
        }
        if ((level = ctx.level()) == null) {
            return;
        }
        RegistryAccess access = level.registryAccess();
        if (flag.hasShiftDown()) {
            TraitConfig config = this.get().getConfig(access);
            list.add((Component)LangData.TOOLTIP_MIN_LEVEL.get(Component.literal((String)("" + config.min_level())).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            list.add((Component)LangData.TOOLTIP_LEVEL_COST.get(Component.literal((String)("" + config.cost())).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
            list.add((Component)LangData.TOOLTIP_WEIGHT.get(Component.literal((String)("" + config.weight())).withStyle(ChatFormatting.DARK_AQUA)).withStyle(ChatFormatting.DARK_GRAY));
        } else {
            this.get().addDetail(access, list);
            list.add((Component)LangData.SHIFT.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        }
    }
}

