/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ReprintHandler {
    public static void reprint(RegistryAccess access, ItemStack dst, ItemStack src) {
        int lv;
        if (!dst.isEnchanted() && !dst.isEnchantable() || !src.isEnchanted()) {
            return;
        }
        HolderLookup.RegistryLookup reg = access.lookupOrThrow(Registries.ENCHANTMENT);
        ItemEnchantments selfEnch = dst.getAllEnchantments(reg);
        ItemEnchantments targetEnch = src.getAllEnchantments(reg);
        LinkedHashMap<Holder<Enchantment>, Integer> newEnch = new LinkedHashMap<Holder<Enchantment>, Integer>();
        for (Object2IntMap.Entry pair : targetEnch.entrySet()) {
            Holder holder = (Holder)pair.getKey();
            if (!dst.isPrimaryItemFor(holder) || !ReprintHandler.allow(newEnch, (Holder<Enchantment>)holder)) continue;
            lv = pair.getIntValue();
            newEnch.compute((Holder<Enchantment>)holder, (k, v) -> v == null ? lv : Math.max(v, lv));
        }
        for (Object2IntMap.Entry pair : selfEnch.entrySet()) {
            Holder holder = (Holder)pair.getKey();
            if (!dst.isPrimaryItemFor(holder) || !ReprintHandler.allow(newEnch, (Holder<Enchantment>)holder)) continue;
            lv = pair.getIntValue();
            newEnch.compute((Holder<Enchantment>)holder, (k, v) -> v == null ? lv : Math.max(v, lv));
        }
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Map.Entry entry : newEnch.entrySet()) {
            builder.set((Holder)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        EnchantmentHelper.setEnchantments((ItemStack)dst, (ItemEnchantments)builder.toImmutable());
    }

    private static boolean allow(Map<Holder<Enchantment>, Integer> map, Holder<Enchantment> ench) {
        if (map.containsKey(ench)) {
            return true;
        }
        for (Holder<Enchantment> e : map.keySet()) {
            if (Enchantment.areCompatible(e, ench)) continue;
            return false;
        }
        return true;
    }
}

